/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallProvider;
import org.jboss.osgi.framework.FutureServiceValue;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.ServiceManagerPlugin;
import org.jboss.osgi.framework.internal.ServiceReferenceWrapper;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

abstract class AbstractBundleContext
implements BundleContext {
    private final AbstractBundleState bundleState;
    private boolean destroyed;

    AbstractBundleContext(AbstractBundleState bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        this.bundleState = bundleState;
    }

    static AbstractBundleContext assertBundleContext(BundleContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (!(context instanceof AbstractBundleContext)) {
            throw new IllegalArgumentException("Not an AbstractBundleContext: " + context);
        }
        return (AbstractBundleContext)context;
    }

    void destroy() {
        this.destroyed = true;
    }

    AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    BundleManager getBundleManager() {
        return this.bundleState.getBundleManager();
    }

    FrameworkState getFrameworkState() {
        return this.bundleState.getFrameworkState();
    }

    public String getProperty(String key) {
        this.checkValidBundleContext();
        this.getBundleManager().assertFrameworkActive();
        Object value = this.getBundleManager().getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    public Bundle getBundle() {
        this.checkValidBundleContext();
        return this.bundleState;
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.installBundleInternal(location, null);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.installBundleInternal(location, input);
    }

    private Bundle installBundleInternal(String location, InputStream input) throws BundleException {
        this.checkValidBundleContext();
        VirtualFile rootFile = null;
        FrameworkState frameworkState = this.getFrameworkState();
        try {
            if (input != null) {
                try {
                    rootFile = AbstractVFS.toVirtualFile((InputStream)input);
                }
                catch (IOException ex) {
                    throw new BundleException("Cannot obtain virtual file from input stream", (Throwable)ex);
                }
            }
            if (rootFile == null) {
                try {
                    URL url = new URL(location);
                    rootFile = AbstractVFS.toVirtualFile((InputStream)url.openStream());
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (rootFile == null) {
                try {
                    File file = new File(location);
                    if (file.exists()) {
                        rootFile = AbstractVFS.toVirtualFile((URI)file.toURI());
                    }
                }
                catch (IOException ex) {
                    throw new BundleException("Cannot obtain virtual file from: " + location, (Throwable)ex);
                }
            }
            if (rootFile == null) {
                throw new BundleException("Cannot obtain virtual file from: " + location);
            }
            DeploymentFactoryPlugin deploymentPlugin = frameworkState.getDeploymentFactoryPlugin();
            Deployment dep = deploymentPlugin.createDeployment(location, rootFile);
            return this.installBundle(dep);
        }
        catch (RuntimeException rte) {
            VFSUtils.safeClose(rootFile);
            throw rte;
        }
        catch (BundleException ex) {
            VFSUtils.safeClose(rootFile);
            throw ex;
        }
    }

    Bundle installBundle(Deployment dep) throws BundleException {
        this.checkValidBundleContext();
        FrameworkState frameworkState = this.getFrameworkState();
        BundleManager bundleManager = frameworkState.getBundleManager();
        ServiceTarget serviceTarget = bundleManager.getServiceTarget();
        BundleInstallProvider installHandler = frameworkState.getCoreServices().getInstallHandler();
        installHandler.installBundle(serviceTarget, dep);
        ServiceName serviceName = (ServiceName)dep.getAttachment(ServiceName.class);
        if (serviceName == null) {
            throw new IllegalArgumentException("Cannot obtain service name for installed bundle: " + dep);
        }
        ServiceContainer serviceContainer = bundleManager.getServiceContainer();
        ServiceController controller = serviceContainer.getService(serviceName);
        FutureServiceValue future = new FutureServiceValue(controller);
        try {
            UserBundleState userBundle = (UserBundleState)future.get(5L, TimeUnit.SECONDS);
            return userBundle;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof BundleException) {
                throw (BundleException)cause;
            }
            throw new BundleException("Cannot install bundle: " + dep.getLocation(), (Throwable)ex);
        }
    }

    public Bundle getBundle(long id) {
        this.checkValidBundleContext();
        AbstractBundleState bundleState = this.getBundleManager().getBundleById(id);
        return bundleState != null ? bundleState : null;
    }

    public Bundle[] getBundles() {
        this.checkValidBundleContext();
        ArrayList<AbstractBundleState> result = new ArrayList<AbstractBundleState>();
        for (AbstractBundleState bundleState : this.getBundleManager().getBundles()) {
            result.add(bundleState);
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().addServiceListener(this.bundleState, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        try {
            this.getFrameworkEventsPlugin().addServiceListener(this.bundleState, listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().removeServiceListener(this.bundleState, listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().addBundleListener(this.bundleState, listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().removeBundleListener(this.bundleState, listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().addFrameworkListener(this.bundleState, listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().removeFrameworkListener(this.bundleState, listener);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState serviceState = serviceManager.registerService(this.bundleState, clazzes, service, properties);
        return serviceState.getRegistration();
    }

    public ServiceReference getServiceReference(String clazz) {
        this.checkValidBundleContext();
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState serviceState = serviceManager.getServiceReference(this.bundleState, clazz);
        return serviceState != null ? new ServiceReferenceWrapper(serviceState) : null;
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState> srefs = serviceManager.getServiceReferences(this.bundleState, clazz, filter, true);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState> srefs = serviceManager.getServiceReferences(this.bundleState, clazz, filter, false);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public Object getService(ServiceReference sref) {
        this.checkValidBundleContext();
        ServiceState serviceState = ServiceState.assertServiceState(sref);
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        Object service = serviceManager.getService(this.bundleState, serviceState);
        return service;
    }

    public boolean ungetService(ServiceReference sref) {
        this.checkValidBundleContext();
        ServiceState serviceState = ServiceState.assertServiceState(sref);
        return this.getServiceManager().ungetService(this.bundleState, serviceState);
    }

    public File getDataFile(String filename) {
        this.checkValidBundleContext();
        BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
        return storagePlugin.getDataFile(this.bundleState, filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        return FrameworkUtil.createFilter((String)filter);
    }

    void checkValidBundleContext() {
        if (this.destroyed) {
            throw new IllegalStateException("Invalid bundle context: " + this);
        }
    }

    private ServiceManagerPlugin getServiceManager() {
        return this.getFrameworkState().getServiceManagerPlugin();
    }

    private FrameworkEventsPlugin getFrameworkEventsPlugin() {
        return this.getFrameworkState().getFrameworkEventsPlugin();
    }

    public String toString() {
        return "BundleContext[" + this.bundleState + "]";
    }
}

