/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionAttributeMarshaller;
import org.jboss.as.clustering.web.infinispan.CoarseSessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.FineSessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.InfinispanWebLogger;
import org.jboss.as.clustering.web.infinispan.InfinispanWebMessages;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactory;
import org.jboss.metadata.web.jboss.ReplicationGranularity;

public class SessionAttributeStorageFactoryImpl
implements SessionAttributeStorageFactory {
    @Override
    public <T extends OutgoingDistributableSessionData> SessionAttributeStorage<T> createStorage(ReplicationGranularity granularity, SessionAttributeMarshaller marshaller) {
        switch (granularity != null ? granularity : ReplicationGranularity.SESSION) {
            case SESSION: {
                return new CoarseSessionAttributeStorage(marshaller);
            }
            case ATTRIBUTE: {
                return new FineSessionAttributeStorage(marshaller);
            }
            case FIELD: {
                InfinispanWebLogger.ROOT_LOGGER.deprecatedGranularity(ReplicationGranularity.FIELD.name(), ReplicationGranularity.SESSION.name());
                return this.createStorage(ReplicationGranularity.SESSION, marshaller);
            }
        }
        throw InfinispanWebMessages.MESSAGES.unknownReplicationGranularity(granularity);
    }
}

