/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.graphic.XGraphic;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextGraphicObjectsSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.XComponentContext;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.LocalOfficeContext;
import org.jodconverter.local.office.utils.Info;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Props;
import org.jodconverter.local.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedImagesEmbedderFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkedImagesEmbedderFilter.class);

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        LOGGER.debug("Applying the LinkedImagesEmbedderFilter");
        if (Write.isText(document)) {
            LinkedImagesEmbedderFilter.convertLinkedImagesToEmbedded(((LocalOfficeContext)context).getComponentContext(), document);
        }
        chain.doFilter(context, document);
    }

    private static void convertLinkedImagesToEmbedded(XComponentContext context, XComponent document) throws Exception {
        XGraphicProvider graphicProvider = Lo.createInstanceMCF(context, XGraphicProvider.class, "com.sun.star.graphic.GraphicProvider");
        XIndexAccess indexAccess = Lo.qi(XIndexAccess.class, Lo.qi(XTextGraphicObjectsSupplier.class, document).getGraphicObjects());
        for (int i = 0; i < indexAccess.getCount(); ++i) {
            XNameContainer bitmapContainer;
            Any xImageAny = (Any)indexAccess.getByIndex(i);
            Object xImageObject = xImageAny.getObject();
            XTextContent xImage = (XTextContent)xImageObject;
            XServiceInfo xInfo = Lo.qi(XServiceInfo.class, xImage);
            if (!xInfo.supportsService("com.sun.star.text.TextGraphicObject")) continue;
            XPropertySet xPropSet = Lo.qi(XPropertySet.class, xImage);
            if (Info.isLibreOffice(context) && Info.compareVersions(Info.getOfficeVersionShort(context), "6.1", 2) >= 0) {
                XGraphic xGraphic = (XGraphic)AnyConverter.toObject(XGraphic.class, (Object)xPropSet.getPropertyValue("Graphic"));
                XPropertySet xGraphicPropSet = Lo.qi(XPropertySet.class, xGraphic);
                boolean linked = (Boolean)xGraphicPropSet.getPropertyValue("Linked");
                if (!linked) continue;
                Objects.requireNonNull(graphicProvider);
                xPropSet.setPropertyValue("Graphic", (Object)graphicProvider.queryGraphic(Props.makeProperties("URL", xGraphicPropSet.getPropertyValue("OriginURL").toString(), "LoadAsLink", false)));
                continue;
            }
            String name = xPropSet.getPropertyValue("LinkDisplayName").toString();
            String graphicUrl = xPropSet.getPropertyValue("GraphicURL").toString();
            if (graphicUrl.contains("vnd.sun.") || (bitmapContainer = Lo.createInstanceMSF(document, XNameContainer.class, "com.sun.star.drawing.BitmapTable")).hasByName(name)) continue;
            bitmapContainer.insertByName(name, (Object)graphicUrl);
            xPropSet.setPropertyValue("GraphicURL", (Object)bitmapContainer.getByName(name).toString());
        }
    }
}

