/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter.text;

import com.sun.star.lang.XComponent;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import com.sun.star.util.XSearchDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextReplacerFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextReplacerFilter.class);
    private final String[] searchList;
    private final String[] replacementList;

    public TextReplacerFilter(@NonNull String[] searchList, @NonNull String[] replacementList) {
        Validate.notEmpty((Object[])searchList, (String)"searchList must not be null nor empty", (Object[])new Object[0]);
        Validate.notEmpty((Object[])replacementList, (String)"replacementList must not be null nor empty", (Object[])new Object[0]);
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        Validate.isTrue((searchLength == replacementLength ? 1 : 0) != 0, (String)"search array length [%d]\u00a0and replacement array length\u00a0[%d] don't match", (Object[])new Object[]{searchLength, replacementLength});
        this.searchList = (String[])ArrayUtils.clone((Object[])searchList);
        this.replacementList = (String[])ArrayUtils.clone((Object[])replacementList);
    }

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws OfficeException {
        LOGGER.debug("Applying the TextReplacerFilter");
        if (Write.isText(document)) {
            this.replaceText(document);
        }
        chain.doFilter(context, document);
    }

    private void replaceText(@NonNull XComponent document) {
        XReplaceable replaceable = Lo.qi(XReplaceable.class, document);
        XReplaceDescriptor replaceDesc = replaceable.createReplaceDescriptor();
        LOGGER.debug("Changing all occurrences of ...");
        for (int i = 0; i < this.searchList.length; ++i) {
            LOGGER.debug("{} -> {}", (Object)this.searchList[i], (Object)this.replacementList[i]);
            replaceDesc.setSearchString(this.searchList[i]);
            replaceDesc.setReplaceString(this.replacementList[i]);
            replaceable.replaceAll((XSearchDescriptor)replaceDesc);
        }
    }
}

