/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractRetryable;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.TemporaryException;
import org.jodconverter.local.office.OfficeConnection;
import org.jodconverter.local.office.OfficeConnectionException;
import org.jodconverter.local.office.OfficeProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectRetryable
extends AbstractRetryable<OfficeException> {
    private static final Integer EXIT_CODE_81 = 81;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectRetryable.class);
    private final OfficeProcess process;
    private final OfficeConnection connection;

    public ConnectRetryable(@NonNull OfficeConnection connection) {
        this(connection, null);
    }

    public ConnectRetryable(@NonNull OfficeConnection connection, @Nullable OfficeProcess process) {
        this.process = process;
        this.connection = connection;
    }

    protected void attempt() throws TemporaryException, OfficeException {
        try {
            this.connection.connect();
        }
        catch (OfficeConnectionException ex) {
            if (this.process == null) {
                throw new TemporaryException((Throwable)((Object)ex));
            }
            Integer exitCode = this.process.getExitCode();
            if (exitCode == null) {
                throw new TemporaryException((Throwable)((Object)ex));
            }
            if (exitCode.equals(EXIT_CODE_81)) {
                LOGGER.warn("Office process died with exit code 81; restarting it");
                this.process.start(true);
                throw new TemporaryException((Throwable)((Object)ex));
            }
            throw new OfficeException("Office process died with exit code " + exitCode, (Throwable)((Object)ex));
        }
    }
}

