/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractOfficeManager;
import org.jodconverter.core.office.InstalledOfficeManagerHolder;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.local.office.ConnectRetryable;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.OfficeConnection;
import org.jodconverter.local.office.OfficeConnectionProtocol;
import org.jodconverter.local.office.OfficeUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalOfficeManager
extends AbstractOfficeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalOfficeManager.class);
    public static final int DEFAULT_PORT_NUMBER = 2002;
    public static final String DEFAULT_PIPE_NAME = "office";
    public static final boolean DEFAULT_CONNECT_ON_START = true;
    public static final long DEFAULT_INITIAL_DELAY = 0L;
    public static final long DEFAULT_CONNECT_TIMEOUT = 120000L;
    public static final long DEFAULT_RETRY_INTERVAL = 250L;
    public static final long MAX_RETRY_INTERVAL = 10000L;
    private final boolean connectOnStart;
    private final long connectTimeout;
    private final long retryInterval;
    private final OfficeConnection connection;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull ExternalOfficeManager make() {
        return ExternalOfficeManager.builder().build();
    }

    public static @NonNull ExternalOfficeManager install() {
        return ((Builder)ExternalOfficeManager.builder().install()).build();
    }

    private ExternalOfficeManager(OfficeUrl officeUrl, File workingDir, Boolean connectOnStart, Long connectTimeout, Long retryInterval) {
        super(workingDir);
        this.connection = new OfficeConnection(officeUrl);
        this.connectOnStart = connectOnStart == null ? true : connectOnStart;
        this.connectTimeout = connectTimeout == null ? 120000L : connectTimeout;
        this.retryInterval = retryInterval == null ? 250L : retryInterval;
    }

    private void connect() throws OfficeException {
        LOGGER.debug("Connecting to external office process...");
        try {
            new ConnectRetryable(this.connection).execute(0L, this.retryInterval, this.connectTimeout);
        }
        catch (Exception ex) {
            throw new OfficeException("Could not establish connection to external office process", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NonNull OfficeTask task) throws OfficeException {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (!this.isRunning()) {
                this.connect();
            }
            LOGGER.debug("Executing task: {}", (Object)task);
            task.execute((OfficeContext)this.connection);
        }
    }

    public boolean isRunning() {
        return this.connection.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws OfficeException {
        if (this.connectOnStart) {
            OfficeConnection officeConnection = this.connection;
            synchronized (officeConnection) {
                this.connect();
                this.makeTempDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (this.isRunning()) {
                try {
                    this.connection.disconnect();
                }
                finally {
                    this.deleteTempDir();
                }
            }
        }
    }

    public static final class Builder
    extends AbstractOfficeManager.AbstractOfficeManagerBuilder<Builder> {
        private OfficeConnectionProtocol connectionProtocol = OfficeConnectionProtocol.SOCKET;
        private Integer portNumber;
        private String pipeName;
        private Boolean connectOnStart;
        private Long connectTimeout;
        private Long retryInterval;

        private Builder() {
        }

        public @NonNull ExternalOfficeManager build() {
            if (this.workingDir == null) {
                this.workingDir = OfficeUtils.getDefaultWorkingDir();
            }
            LocalOfficeUtils.validateOfficeWorkingDirectory(this.workingDir);
            ExternalOfficeManager manager = new ExternalOfficeManager(this.connectionProtocol == OfficeConnectionProtocol.SOCKET ? (this.portNumber == null ? new OfficeUrl(2002) : new OfficeUrl(this.portNumber)) : (this.pipeName == null ? new OfficeUrl(ExternalOfficeManager.DEFAULT_PIPE_NAME) : new OfficeUrl(this.pipeName)), this.workingDir, this.connectOnStart, this.connectTimeout, this.retryInterval);
            if (this.install) {
                InstalledOfficeManagerHolder.setInstance((OfficeManager)manager);
            }
            return manager;
        }

        public @NonNull Builder connectionProtocol(@Nullable OfficeConnectionProtocol connectionProtocol) {
            this.connectionProtocol = connectionProtocol;
            return this;
        }

        public @NonNull Builder pipeName(@Nullable String pipeName) {
            if (StringUtils.isNotBlank((CharSequence)pipeName)) {
                this.pipeName = pipeName;
            }
            return this;
        }

        public @NonNull Builder portNumber(@Nullable Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public @NonNull Builder connectOnStart(@Nullable Boolean connectOnStart) {
            this.connectOnStart = connectOnStart;
            return this;
        }

        public @NonNull Builder connectTimeout(@Nullable Long connectTimeout) {
            if (connectTimeout != null) {
                Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)connectTimeout, (String)String.format("connectTimeout %s must be greater than or equal to 0", connectTimeout));
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public @NonNull Builder retryInterval(@Nullable Long retryInterval) {
            if (retryInterval != null) {
                Validate.inclusiveBetween((long)0L, (long)10000L, (long)retryInterval, (String)String.format("retryInterval %s must be in the inclusive range of %s to %s", retryInterval, 0, 10000L));
            }
            this.retryInterval = retryInterval;
            return this;
        }
    }
}

