/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractOfficeManagerPool;
import org.jodconverter.core.office.InstalledOfficeManagerHolder;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.OfficeProcessManagerPoolEntry;
import org.jodconverter.local.office.OfficeUrl;
import org.jodconverter.local.process.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalOfficeManager
extends AbstractOfficeManagerPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalOfficeManager.class);

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull LocalOfficeManager make() {
        return LocalOfficeManager.builder().build();
    }

    public static @NonNull LocalOfficeManager install() {
        return ((Builder)LocalOfficeManager.builder().install()).build();
    }

    private LocalOfficeManager(List<OfficeUrl> officeUrls, File officeHome, File workingDir, ProcessManager processManager, List<String> runAsArgs, File templateProfileDir, Boolean killExistingProcess, Long processTimeout, Long processRetryInterval, Long taskExecutionTimeout, Integer maxTasksPerProcess, Boolean disableOpengl, Long taskQueueTimeout) {
        super(workingDir, Integer.valueOf(officeUrls.size()), taskQueueTimeout);
        this.setEntries(officeUrls.stream().map(officeUrl -> new OfficeProcessManagerPoolEntry((OfficeUrl)officeUrl, officeHome, workingDir, processManager, runAsArgs, templateProfileDir, killExistingProcess, processTimeout, processRetryInterval, taskExecutionTimeout, maxTasksPerProcess, disableOpengl)).collect(Collectors.toList()));
    }

    public static final class Builder
    extends AbstractOfficeManagerPool.AbstractOfficeManagerPoolBuilder<Builder> {
        private static final long MIN_PROCESS_RETRY_INTERVAL = 0L;
        private static final long MAX_PROCESS_RETRY_INTERVAL = 10000L;
        private List<String> pipeNames;
        private List<Integer> portNumbers;
        private File officeHome;
        private ProcessManager processManager;
        private List<String> runAsArgs;
        private File templateProfileDir;
        private boolean useDefaultOnInvalidTemplateProfileDir;
        private Boolean killExistingProcess;
        private Long processTimeout;
        private Long processRetryInterval;
        private Integer maxTasksPerProcess;
        private Boolean disableOpengl;

        private Builder() {
        }

        public @NonNull LocalOfficeManager build() {
            if (this.officeHome == null) {
                this.officeHome = LocalOfficeUtils.getDefaultOfficeHome();
            }
            if (this.workingDir == null) {
                this.workingDir = OfficeUtils.getDefaultWorkingDir();
            }
            if (this.processManager == null) {
                this.processManager = LocalOfficeUtils.findBestProcessManager();
            }
            LocalOfficeUtils.validateOfficeHome(this.officeHome);
            LocalOfficeUtils.validateOfficeWorkingDirectory(this.workingDir);
            if (this.useDefaultOnInvalidTemplateProfileDir) {
                try {
                    LocalOfficeUtils.validateOfficeTemplateProfileDirectory(this.templateProfileDir);
                }
                catch (IllegalStateException ex) {
                    this.templateProfileDir = null;
                    LOGGER.warn("Falling back to default templateProfileDir. Cause: {}", (Object)ex.getMessage());
                }
            } else {
                LocalOfficeUtils.validateOfficeTemplateProfileDirectory(this.templateProfileDir);
            }
            LocalOfficeManager manager = new LocalOfficeManager(LocalOfficeUtils.buildOfficeUrls(this.portNumbers, this.pipeNames), this.officeHome, this.workingDir, this.processManager, this.runAsArgs, this.templateProfileDir, this.killExistingProcess, this.processTimeout, this.processRetryInterval, this.taskExecutionTimeout, this.maxTasksPerProcess, this.disableOpengl, this.taskQueueTimeout);
            if (this.install) {
                InstalledOfficeManagerHolder.setInstance((OfficeManager)manager);
            }
            return manager;
        }

        public @NonNull Builder pipeNames(String ... pipeNames) {
            if (pipeNames != null && pipeNames.length != 0) {
                this.pipeNames = Arrays.asList(pipeNames);
            }
            return this;
        }

        public @NonNull Builder portNumbers(int ... portNumbers) {
            if (portNumbers != null && portNumbers.length != 0) {
                this.portNumbers = Arrays.stream(portNumbers).boxed().collect(Collectors.toList());
            }
            return this;
        }

        public @NonNull Builder officeHome(@Nullable File officeHome) {
            this.officeHome = officeHome;
            return this;
        }

        public @NonNull Builder officeHome(@Nullable String officeHome) {
            return StringUtils.isBlank((CharSequence)officeHome) ? this : this.officeHome(new File(officeHome));
        }

        public @NonNull Builder processManager(@Nullable ProcessManager processManager) {
            this.processManager = processManager;
            return this;
        }

        public @NonNull Builder processManager(@Nullable String processManagerClass) {
            try {
                return StringUtils.isBlank((CharSequence)processManagerClass) ? this : this.processManager((ProcessManager)Class.forName(processManagerClass).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new IllegalArgumentException("Unable to create a Process manager from the specified class name: " + processManagerClass, ex);
            }
        }

        public @NonNull Builder runAsArgs(String ... runAsArgs) {
            if (runAsArgs != null && runAsArgs.length != 0) {
                this.runAsArgs = Arrays.asList(runAsArgs);
            }
            return this;
        }

        public @NonNull Builder templateProfileDir(@Nullable File templateProfileDir) {
            this.templateProfileDir = templateProfileDir;
            return this;
        }

        public @NonNull Builder templateProfileDir(@Nullable String templateProfileDir) {
            return StringUtils.isBlank((CharSequence)templateProfileDir) ? this : this.templateProfileDir(new File(templateProfileDir));
        }

        public @NonNull Builder templateProfileDirOrDefault(@Nullable File templateProfileDir) {
            if (templateProfileDir != null) {
                this.useDefaultOnInvalidTemplateProfileDir = true;
            }
            this.templateProfileDir = templateProfileDir;
            return this;
        }

        public @NonNull Builder templateProfileDirOrDefault(@Nullable String templateProfileDir) {
            return StringUtils.isBlank((CharSequence)templateProfileDir) ? this : this.templateProfileDirOrDefault(new File(templateProfileDir));
        }

        public @NonNull Builder killExistingProcess(@Nullable Boolean killExistingProcess) {
            this.killExistingProcess = killExistingProcess;
            return this;
        }

        public @NonNull Builder processTimeout(@Nullable Long processTimeout) {
            if (processTimeout != null) {
                Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)processTimeout, (String)String.format("processTimeout %s must be greater than or equal to 0", processTimeout));
            }
            this.processTimeout = processTimeout;
            return this;
        }

        public @NonNull Builder processRetryInterval(@Nullable Long processRetryInterval) {
            if (processRetryInterval != null) {
                Validate.inclusiveBetween((long)0L, (long)10000L, (long)processRetryInterval, (String)String.format("processRetryInterval %s must be in the inclusive range of %s to %s", processRetryInterval, 0L, 10000L));
            }
            this.processRetryInterval = processRetryInterval;
            return this;
        }

        public @NonNull Builder maxTasksPerProcess(@Nullable Integer maxTasksPerProcess) {
            if (maxTasksPerProcess != null) {
                Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)maxTasksPerProcess.intValue(), (String)String.format("maxTasksPerProcess %s must be greater than 0", maxTasksPerProcess));
            }
            this.maxTasksPerProcess = maxTasksPerProcess;
            return this;
        }

        public @NonNull Builder disableOpengl(@Nullable Boolean disableOpengl) {
            this.disableOpengl = disableOpengl;
            return this;
        }
    }
}

