/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import com.sun.star.lang.DisposedException;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jodconverter.core.office.NamedThreadFactory;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.RetryTimeoutException;
import org.jodconverter.local.office.ConnectRetryable;
import org.jodconverter.local.office.OfficeConnection;
import org.jodconverter.local.office.OfficeProcess;
import org.jodconverter.local.office.OfficeUrl;
import org.jodconverter.local.process.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OfficeProcessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeProcessManager.class);
    private static final long DEFAULT_PROCESS_INITIAL_DELAY = 0L;
    private static final long DEFAULT_PROCESS_TIMEOUT = 120000L;
    private static final long DEFAULT_PROCESS_RETRY_INTERVAL = 250L;
    private final OfficeProcess process;
    private final OfficeConnection connection;
    private final ExecutorService executor;
    private final long processTimeout;
    private final long processRetryInterval;

    public OfficeProcessManager(OfficeUrl officeUrl, File officeHome, File workingDir, ProcessManager processManager, List<String> runAsArgs, File templateProfileDir, Boolean killExistingProcess, Long processTimeout, Long processRetryInterval) {
        this.process = new OfficeProcess(officeUrl, officeHome, workingDir, processManager, runAsArgs, templateProfileDir, killExistingProcess);
        this.connection = new OfficeConnection(officeUrl);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("jodconverter-officeprocess"));
        this.processTimeout = processTimeout == null ? 120000L : processTimeout;
        this.processRetryInterval = processRetryInterval == null ? 250L : processRetryInterval;
    }

    private void doEnsureProcessExited(boolean deleteInstanceProfileDir) throws OfficeException {
        try {
            int exitCode = this.process.getExitCode(this.processRetryInterval, this.processTimeout);
            LOGGER.info("Process exited with code {}", (Object)exitCode);
        }
        catch (RetryTimeoutException retryTimeoutEx) {
            LOGGER.debug("doEnsureProcessExited times out", (Throwable)retryTimeoutEx);
            this.doTerminateProcess();
        }
        finally {
            if (deleteInstanceProfileDir) {
                this.process.deleteInstanceProfileDir();
            }
        }
    }

    private void doStartProcessAndConnect(boolean restart) throws OfficeException {
        this.process.start(restart);
        try {
            new ConnectRetryable(this.connection, this.process).execute(0L, this.processRetryInterval, this.processTimeout);
        }
        catch (OfficeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OfficeException("Could not establish connection", (Throwable)ex);
        }
    }

    private void doStopProcess(boolean deleteInstanceProfileDir) throws OfficeException {
        try {
            boolean terminated = this.connection.getDesktop().terminate();
            LOGGER.debug("The Office Process {}", (Object)(terminated ? "has been terminated" : "is still running. Someone else prevents termination, e.g. the quickstarter"));
        }
        catch (DisposedException disposedEx) {
            LOGGER.debug("Expected DisposedException catch and ignored in doStopProcess", (Throwable)disposedEx);
        }
        catch (Exception ex) {
            LOGGER.debug("Exception catch in doStopProcess", (Throwable)ex);
            this.doTerminateProcess();
        }
        finally {
            this.doEnsureProcessExited(deleteInstanceProfileDir);
        }
    }

    private void doTerminateProcess() throws OfficeException {
        try {
            int exitCode = this.process.forciblyTerminate(this.processRetryInterval, this.processTimeout);
            LOGGER.info("Process terminated with code {}", (Object)exitCode);
        }
        catch (Exception ex) {
            throw new OfficeException("Could not terminate process", (Throwable)ex);
        }
    }

    OfficeConnection getConnection() {
        return this.connection;
    }

    public void restartAndWait() throws OfficeException {
        this.submitAndWait("Restart", () -> {
            this.doStopProcess(false);
            this.doStartProcessAndConnect(true);
            return null;
        });
    }

    public void restartDueToLostConnection() {
        LOGGER.info("Executing task 'Restart After Lost Connection'...");
        this.executor.execute(() -> {
            try {
                this.doEnsureProcessExited(true);
                this.doStartProcessAndConnect(false);
            }
            catch (OfficeException officeEx) {
                LOGGER.error("Could not restart process after connection lost.", (Throwable)officeEx);
            }
        });
    }

    public void restartDueToTaskTimeout() {
        LOGGER.info("Executing task 'Restart After Timeout'...");
        this.executor.execute(() -> {
            try {
                this.doTerminateProcess();
            }
            catch (OfficeException officeException) {
                LOGGER.error("Could not terminate process after task timeout.", (Throwable)officeException);
            }
        });
    }

    public void startAndWait() throws OfficeException {
        this.submitAndWait("Start", () -> {
            this.doStartProcessAndConnect(false);
            return null;
        });
    }

    public void stopAndWait() throws OfficeException {
        this.submitAndWait("Stop", () -> {
            this.doStopProcess(true);
            return null;
        });
    }

    private void submitAndWait(String taskName, Callable<Void> task) throws OfficeException {
        LOGGER.info("Submitting task '{}' and waiting...", (Object)taskName);
        Future<Void> future = this.executor.submit(task);
        try {
            future.get();
            LOGGER.debug("Task executed successfully: {}", (Object)taskName);
        }
        catch (ExecutionException executionEx) {
            LOGGER.debug("ExecutionException catch in submitAndWait for task: " + taskName, (Throwable)executionEx);
            if (executionEx.getCause() instanceof OfficeException) {
                throw (OfficeException)executionEx.getCause();
            }
            throw new OfficeException("Failed to execute task: " + taskName, executionEx.getCause());
        }
        catch (InterruptedException interruptedEx) {
            Thread.currentThread().interrupt();
        }
    }
}

