/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Objects;

public class AssetClassLoader {
    public static ClassLoader classLoader(ClassLoader parent) throws IOException {
        return AssetClassLoader.classLoader(parent, new File(System.getProperty("user.dir")));
    }

    public static ClassLoader classLoader(ClassLoader parent, File projectDir) throws IOException {
        Objects.requireNonNull(parent, "ClassLoader required.");
        File publicDir = new File(projectDir, "public");
        if (publicDir.exists()) {
            return new URLClassLoader(new URL[]{publicDir.toURI().toURL()}, parent);
        }
        return parent;
    }
}

