/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.base.CaseFormat;
import com.typesafe.config.Config;
import org.jooby.MediaType;
import org.jooby.assets.AssetOptions;
import org.jooby.assets.Engine;
import org.jooby.assets.EngineFactory;

public abstract class AssetProcessor
extends AssetOptions {
    protected EngineFactory engineFactory;

    public String name() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.getClass().getSimpleName());
    }

    @Override
    public AssetProcessor set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public AssetProcessor set(Config options) {
        super.set(options);
        return this;
    }

    public abstract boolean matches(MediaType var1);

    public String process(String filename, String source, Config conf) throws Exception {
        return this.process(filename, source, conf, this.getClass().getClassLoader());
    }

    public abstract String process(String var1, String var2, Config var3, ClassLoader var4) throws Exception;

    public AssetProcessor set(EngineFactory factory) {
        this.engineFactory = factory;
        return this;
    }

    protected <T extends Engine> T engine(Class<T> type) {
        return this.engine(type, null);
    }

    protected <T extends Engine> T engine(Class<T> type, String scope) {
        if (this.engineFactory == null) {
            throw new IllegalStateException("No JavaScript engine available");
        }
        return (T)((Engine)type.cast(this.engineFactory.get(this.getClass().getSimpleName(), scope)));
    }

    public String toString() {
        return this.name();
    }
}

