/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.hbm;

import com.google.common.reflect.Reflection;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jooby.Registry;

public class GuiceBeanManager {
    public static BeanManager beanManager(CompletableFuture<Registry> injector) {
        return (BeanManager)Reflection.newProxy(BeanManager.class, (proxy, method, args) -> {
            String name;
            switch (name = method.getName()) {
                case "createAnnotatedType": {
                    return GuiceBeanManager.createAnnotatedType((Class)args[0]);
                }
                case "createInjectionTarget": {
                    return GuiceBeanManager.createInjectionTarget(injector, ((AnnotatedType)args[0]).getJavaClass());
                }
                case "createCreationalContext": {
                    return GuiceBeanManager.createCreationalContext();
                }
                case "toString": {
                    return injector.toString();
                }
            }
            throw new UnsupportedOperationException(method.toString());
        });
    }

    private static <T> InjectionTarget<T> createInjectionTarget(CompletableFuture<Registry> injector, Class<T> type) {
        return (InjectionTarget)Reflection.newProxy(InjectionTarget.class, (proxy, method, args) -> {
            String name;
            switch (name = method.getName()) {
                case "produce": {
                    return ((Registry)injector.get()).require(type);
                }
                case "inject": {
                    return null;
                }
                case "postConstruct": {
                    return null;
                }
                case "preDestroy": {
                    return null;
                }
                case "dispose": {
                    return null;
                }
            }
            throw new UnsupportedOperationException(method.toString());
        });
    }

    private static <T> CreationalContext<T> createCreationalContext() {
        return (CreationalContext)Reflection.newProxy(CreationalContext.class, (proxy, method, args) -> {
            if (method.getName().equals("release")) {
                return null;
            }
            throw new UnsupportedOperationException(method.toString());
        });
    }

    private static <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        return (AnnotatedType)Reflection.newProxy(AnnotatedType.class, (proxy, method, args) -> {
            if (method.getName().equals("getJavaClass")) {
                return type;
            }
            throw new UnsupportedOperationException(method.toString());
        });
    }
}

