/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jooby.Command;
import org.jooby.ExternalCommand;
import org.jooby.RunApp;
import org.jooby.RunForkedApp;
import org.jooby.funzy.Try;
import org.jooby.run.Watcher;

@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class JoobyMojo
extends AbstractMojo {
    private static final Object LOCK = new Object();
    private static final List<String> XML_PROPS = Arrays.asList("javax.xml.parsers.DocumentBuilderFactory", "javax.xml.parsers.SAXParserFactory", "javax.xml.stream.XMLInputFactory", "javax.xml.stream.XMLEventFactory", "javax.xml.transform.TransformerFactory", "javax.xml.stream.XMLOutputFactory", "javax.xml.datatype.DatatypeFactory", "org.xml.sax.driver");
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(property="main.class", defaultValue="${application.class}")
    protected String mainClass;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String buildOutputDirectory;
    @Parameter(property="jooby.commands")
    private List<ExternalCommand> commands;
    @Parameter(property="jooby.vmArgs")
    private List<String> vmArgs;
    @Parameter(property="jooby.includes")
    private List<String> includes;
    @Parameter(property="jooby.watchDirs")
    private List<String> watchDirs;
    @Parameter(property="jooby.excludes")
    private List<String> excludes;
    @Parameter(property="jooby.srcExtensions", defaultValue=".java,.kt,.conf,.properties")
    private List<String> srcExtensions;
    @Parameter(property="application.debug", defaultValue="true")
    private String debug;
    @Parameter(defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    @Parameter(property="compiler", defaultValue="on")
    private String compiler;
    @Component
    protected Maven maven;
    @Parameter(property="application.fork", defaultValue="false")
    private boolean fork = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LinkedHashSet<File> appcp = new LinkedHashSet<File>();
        appcp.addAll(JoobyMojo.resources(this.mavenProject.getResources()));
        appcp.add(new File(this.buildOutputDirectory));
        Set<Artifact> references = this.references(this.mavenProject);
        Set<File> refbasedir = this.refbasedir(this.mavenProject, references);
        Set<File> refcp = this.refcp(refbasedir);
        appcp.addAll(refcp);
        LinkedHashSet artifacts = new LinkedHashSet(this.mavenProject.getArtifacts());
        artifacts.forEach(artifact -> {
            if (!"pom".equals(artifact.getType())) {
                appcp.add(new File(artifact.getFile().getAbsolutePath()));
            }
        });
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        File hotreload = this.extra(this.pluginArtifacts, "jooby-run");
        File jbossModules = this.extra(this.pluginArtifacts, "jboss-modules");
        classpath.add(hotreload);
        classpath.add(jbossModules);
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (this.commands != null && this.commands.size() > 0) {
            cmds.addAll(this.commands);
        }
        ArrayList<File> watchDirs = new ArrayList<File>();
        watchDirs.add(this.mavenProject.getBasedir());
        watchDirs.addAll(refbasedir);
        if (this.watchDirs != null) {
            this.watchDirs.forEach(f -> watchDirs.add(new File((String)f)));
        }
        String includes = null;
        if (this.includes != null && this.includes.size() > 0) {
            includes = this.includes.stream().collect(Collectors.joining(File.pathSeparator));
        }
        String excludes = null;
        if (this.excludes != null && this.excludes.size() > 0) {
            excludes = this.excludes.stream().collect(Collectors.joining(File.pathSeparator));
        }
        String watchDirStr = watchDirs.stream().filter(File::exists).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        String mId = this.mavenProject.getGroupId() + "." + this.mavenProject.getArtifactId();
        this.setLogback();
        System.setProperty("application.version", this.mavenProject.getVersion());
        Command runapp = this.fork ? new RunForkedApp(this.mavenProject.getBasedir(), this.debug, this.vmArgs, classpath, mId, this.mainClass, appcp, includes, excludes, watchDirStr) : new RunApp(mId, this.mainClass, appcp, includes, excludes, watchDirs);
        cmds.add(runapp);
        for (Command cmd : cmds) {
            cmd.setWorkdir(this.mavenProject.getBasedir());
            this.getLog().debug((CharSequence)("cmd: " + cmd.debug()));
        }
        Watcher watcher = JoobyMojo.setupCompiler(this.mavenProject, this.compiler, this.srcExtensions, goal -> this.maven.execute(DefaultMavenExecutionRequest.copy((MavenExecutionRequest)this.session.getRequest()).setGoals(Arrays.asList(goal))));
        ShutdownHook shutdownHook = new ShutdownHook(this.getLog(), cmds);
        shutdownHook.watcher = watcher;
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        if (watcher != null) {
            watcher.start();
        }
        for (Command cmd : cmds) {
            try {
                this.getLog().debug((CharSequence)("Starting process: " + cmd.debug()));
                cmd.execute();
            }
            catch (Exception ex) {
                throw new MojoFailureException("Execution of " + cmd + " resulted in error", (Throwable)ex);
            }
        }
    }

    private Set<Artifact> references(MavenProject project) {
        List modules;
        MavenProject parent = project.getParent();
        if (parent != null && (modules = parent.getModules()) != null) {
            LinkedHashSet artifacts = new LinkedHashSet(this.mavenProject.getArtifacts());
            String groupId = project.getGroupId();
            String version = project.getVersion();
            return artifacts.stream().filter(a -> a.getGroupId().equals(groupId) && a.getVersion().equals(version) && modules.contains(a.getArtifactId())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Set<File> refbasedir(MavenProject project, Set<Artifact> references) {
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        for (Artifact reference : references) {
            File basedir = project.getParent().getBasedir();
            cp.add(new File(basedir, reference.getArtifactId()));
        }
        return cp;
    }

    private Set<File> refcp(Set<File> files) {
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        for (File basedir : files) {
            cp.add(new File(new File(basedir, "target"), "classes"));
        }
        return cp;
    }

    private static Watcher setupCompiler(MavenProject project, String compiler, List<String> srcExtensions, Consumer<String> task) throws MojoFailureException {
        File eclipseClasspath = new File(project.getBasedir(), ".classpath");
        if ("off".equalsIgnoreCase(compiler) || eclipseClasspath.exists()) {
            return null;
        }
        List<File> resources = JoobyMojo.resources(project.getResources());
        resources.add(0, new File(project.getBuild().getSourceDirectory()));
        List<Path> paths = resources.stream().filter(File::exists).map(File::toPath).collect(Collectors.toList());
        try {
            ClassLoader backloader = Thread.currentThread().getContextClassLoader();
            return new Watcher((kind, path) -> {
                ClassLoader currentloader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(backloader);
                    if (srcExtensions.stream().anyMatch(ext -> path.toString().endsWith((String)ext))) {
                        JoobyMojo.runCompile(task);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentloader);
                }
            }, paths.toArray(new Path[paths.size()]));
        }
        catch (Exception ex) {
            throw new MojoFailureException("Can't compile source code", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCompile(Consumer<String> task) {
        Object object = LOCK;
        synchronized (object) {
            HashMap<String, String> xml = new HashMap<String, String>();
            XML_PROPS.forEach(p -> xml.put((String)p, (String)System.getProperties().remove(p)));
            task.accept("process-classes");
            xml.forEach((k, v) -> {
                if (v != null) {
                    System.setProperty(k, v);
                }
            });
        }
    }

    private void setLogback() {
        File[] logbackFiles;
        for (File logback : logbackFiles = new File[]{this.localFile("conf", "logback-test.xml"), this.localFile("conf", "logback.dev.xml"), this.localFile("conf", "logback.xml")}) {
            if (!logback.exists()) continue;
            System.setProperty("logback.configurationFile", logback.getAbsolutePath());
            break;
        }
    }

    private File localFile(String ... paths) {
        File result = this.mavenProject.getBasedir();
        for (String path : paths) {
            result = new File(result, path);
        }
        return result;
    }

    private static List<File> resources(Iterable<Resource> resources) {
        ArrayList<File> result = new ArrayList<File>();
        for (Resource resource : resources) {
            String dir = resource.getDirectory();
            File file = new File(dir);
            if (!file.exists()) continue;
            result.add(file);
        }
        return result;
    }

    private File extra(List<Artifact> artifacts, String name) {
        return (File)Try.apply(() -> {
            for (Artifact artifact : artifacts) {
                for (String tail : artifact.getDependencyTrail()) {
                    if (!tail.contains(name)) continue;
                    return artifact.getFile();
                }
            }
            throw new FileNotFoundException(name);
        }).get();
    }

    private static class ShutdownHook
    extends Thread {
        private Log log;
        private List<Command> commands;
        private Watcher watcher;

        public ShutdownHook(Log log, List<Command> commands) {
            this.log = log;
            this.commands = commands;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (this.watcher != null) {
                this.log.debug((CharSequence)"stopping: watcher");
                Try.run(() -> ((Watcher)this.watcher).stop()).onFailure(ex -> this.log.debug((CharSequence)"Stop of watcher resulted in error", ex));
            }
            this.commands.forEach(cmd -> {
                this.log.debug((CharSequence)("stopping: " + cmd));
                Try.run(cmd::stop).onFailure(ex -> this.log.error((CharSequence)("Stop of " + cmd + " resulted in error"), ex));
            });
        }
    }
}

