/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jwt.signer.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.JsonParseException;
import com.nimbusds.jose.jwk.JWKSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.jose.keystore.JWKSetKeyStore;
import org.mitre.jwt.encryption.service.JWTEncryptionAndDecryptionService;
import org.mitre.jwt.encryption.service.impl.DefaultJWTEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.DefaultJWTSigningAndValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class JWKSetCacheService {
    private static final Logger logger = LoggerFactory.getLogger(JWKSetCacheService.class);
    private LoadingCache<String, JWTSigningAndValidationService> validators = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new JWKSetVerifierFetcher((HttpClient)HttpClientBuilder.create().useSystemProperties().build()));
    private LoadingCache<String, JWTEncryptionAndDecryptionService> encrypters = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new JWKSetEncryptorFetcher((HttpClient)HttpClientBuilder.create().useSystemProperties().build()));

    public JWTSigningAndValidationService getValidator(String jwksUri) {
        try {
            return (JWTSigningAndValidationService)this.validators.get((Object)jwksUri);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            logger.warn("Couldn't load JWK Set from " + jwksUri + ": " + e.getMessage());
            return null;
        }
    }

    public JWTEncryptionAndDecryptionService getEncrypter(String jwksUri) {
        try {
            return (JWTEncryptionAndDecryptionService)this.encrypters.get((Object)jwksUri);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            logger.warn("Couldn't load JWK Set from " + jwksUri + ": " + e.getMessage());
            return null;
        }
    }

    private class JWKSetEncryptorFetcher
    extends CacheLoader<String, JWTEncryptionAndDecryptionService> {
        private HttpComponentsClientHttpRequestFactory httpFactory;
        private RestTemplate restTemplate;

        public JWKSetEncryptorFetcher(HttpClient httpClient) {
            this.httpFactory = new HttpComponentsClientHttpRequestFactory(httpClient);
            this.restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);
        }

        public JWTEncryptionAndDecryptionService load(String key) throws Exception {
            try {
                String jsonString = (String)this.restTemplate.getForObject(key, String.class, new Object[0]);
                JWKSet jwkSet = JWKSet.parse((String)jsonString);
                JWKSetKeyStore keyStore = new JWKSetKeyStore(jwkSet);
                DefaultJWTEncryptionAndDecryptionService service = new DefaultJWTEncryptionAndDecryptionService(keyStore);
                return service;
            }
            catch (JsonParseException | RestClientException e) {
                throw new IllegalArgumentException("Unable to load JWK Set");
            }
        }
    }

    private class JWKSetVerifierFetcher
    extends CacheLoader<String, JWTSigningAndValidationService> {
        private HttpComponentsClientHttpRequestFactory httpFactory;
        private RestTemplate restTemplate;

        JWKSetVerifierFetcher(HttpClient httpClient) {
            this.httpFactory = new HttpComponentsClientHttpRequestFactory(httpClient);
            this.restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);
        }

        public JWTSigningAndValidationService load(String key) throws Exception {
            String jsonString = (String)this.restTemplate.getForObject(key, String.class, new Object[0]);
            JWKSet jwkSet = JWKSet.parse((String)jsonString);
            JWKSetKeyStore keyStore = new JWKSetKeyStore(jwkSet);
            DefaultJWTSigningAndValidationService service = new DefaultJWTSigningAndValidationService(keyStore);
            return service;
        }
    }
}

