/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.assertion.impl;

import com.google.common.collect.Sets;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.mitre.oauth2.assertion.AssertionOAuth2RequestFactory;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;

public class DirectCopyRequestFactory
implements AssertionOAuth2RequestFactory {
    @Override
    public OAuth2Request createOAuth2Request(ClientDetails client, TokenRequest tokenRequest, JWT assertion) {
        try {
            JWTClaimsSet claims = assertion.getJWTClaimsSet();
            Set scope = OAuth2Utils.parseParameterList((String)claims.getStringClaim("scope"));
            HashSet resources = Sets.newHashSet((Iterable)claims.getAudience());
            return new OAuth2Request(tokenRequest.getRequestParameters(), client.getClientId(), client.getAuthorities(), true, scope, (Set)resources, null, null, null);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

