/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.token;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Component;

@Component(value="chainedTokenGranter")
public class ChainedTokenGranter
extends AbstractTokenGranter {
    public static final String GRANT_TYPE = "urn:ietf:params:oauth:grant_type:redelegate";
    private OAuth2TokenEntityService tokenServices;

    @Autowired
    public ChainedTokenGranter(OAuth2TokenEntityService tokenServices, ClientDetailsEntityService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super((AuthorizationServerTokenServices)tokenServices, (ClientDetailsService)clientDetailsService, requestFactory, GRANT_TYPE);
        this.tokenServices = tokenServices;
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) throws AuthenticationException, InvalidTokenException {
        String incomingTokenValue = (String)tokenRequest.getRequestParameters().get("token");
        OAuth2AccessTokenEntity incomingToken = this.tokenServices.readAccessToken(incomingTokenValue);
        Set approvedScopes = incomingToken.getScope();
        HashSet requestedScopes = tokenRequest.getScope();
        if (requestedScopes == null) {
            requestedScopes = new HashSet();
        }
        if (client.getScope().equals(requestedScopes)) {
            requestedScopes = new HashSet();
        }
        if (approvedScopes.containsAll(requestedScopes)) {
            if (requestedScopes.isEmpty()) {
                tokenRequest.setScope((Collection)approvedScopes);
            } else {
                tokenRequest.setScope((Collection)Sets.intersection(requestedScopes, (Set)approvedScopes));
            }
            OAuth2Authentication authentication = new OAuth2Authentication(this.getRequestFactory().createOAuth2Request(client, tokenRequest), incomingToken.getAuthenticationHolder().getAuthentication().getUserAuthentication());
            return authentication;
        }
        throw new InvalidScopeException("Invalid scope requested in chained request", approvedScopes);
    }
}

