/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.mitre.oauth2.exception.DeviceCodeCreationException;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.DeviceCode;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.DeviceCodeService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DeviceEndpoint {
    public static final String URL = "devicecode";
    public static final String USER_URL = "device";
    public static final Logger logger = LoggerFactory.getLogger(DeviceEndpoint.class);
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private DeviceCodeService deviceCodeService;
    @Autowired
    private OAuth2RequestFactory oAuth2RequestFactory;

    @RequestMapping(value={"/devicecode"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    public String requestDeviceCode(@RequestParam(value="client_id") String clientId, @RequestParam(name="scope", required=false) String scope, Map<String, String> parameters, ModelMap model) {
        ClientDetailsEntity client;
        try {
            client = this.clientService.loadClientByClientId(clientId);
            Set authorizedGrantTypes = client.getAuthorizedGrantTypes();
            if (authorizedGrantTypes != null && !authorizedGrantTypes.isEmpty() && !authorizedGrantTypes.contains("urn:ietf:params:oauth:grant-type:device_code")) {
                throw new InvalidClientException("Unauthorized grant type: urn:ietf:params:oauth:grant-type:device_code");
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("IllegalArgumentException was thrown when attempting to load client", (Throwable)e);
            model.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        if (client == null) {
            logger.error("could not find client " + clientId);
            model.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        Set requestedScopes = OAuth2Utils.parseParameterList((String)scope);
        Set allowedScopes = client.getScope();
        if (!this.scopeService.scopesMatch(allowedScopes, requestedScopes)) {
            logger.error("Client asked for " + requestedScopes + " but is allowed " + allowedScopes);
            model.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            model.put((Object)"error", (Object)"invalid_scope");
            return "jsonErrorView";
        }
        try {
            DeviceCode dc = this.deviceCodeService.createNewDeviceCode(requestedScopes, client, parameters);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("device_code", dc.getDeviceCode());
            response.put("user_code", dc.getUserCode());
            response.put("verification_uri", this.config.getIssuer() + USER_URL);
            if (client.getDeviceCodeValiditySeconds() != null) {
                response.put("expires_in", client.getDeviceCodeValiditySeconds());
            }
            model.put((Object)"entity", response);
            return "jsonEntityView";
        }
        catch (DeviceCodeCreationException dcce) {
            model.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            model.put((Object)"error", (Object)dcce.getError());
            model.put((Object)"errorMessage", (Object)dcce.getMessage());
            return "jsonErrorView";
        }
    }

    @PreAuthorize(value="hasRole('ROLE_USER')")
    @RequestMapping(value={"/device"}, method={RequestMethod.GET})
    public String requestUserCode(ModelMap model) {
        return "requestUserCode";
    }

    @PreAuthorize(value="hasRole('ROLE_USER')")
    @RequestMapping(value={"/device/verify"}, method={RequestMethod.POST})
    public String readUserCode(@RequestParam(value="user_code") String userCode, ModelMap model, HttpSession session) {
        DeviceCode dc = this.deviceCodeService.lookUpByUserCode(userCode);
        if (dc == null) {
            model.addAttribute("error", (Object)"noUserCode");
            return "requestUserCode";
        }
        if (dc.getExpiration() != null && dc.getExpiration().before(new Date())) {
            model.addAttribute("error", (Object)"expiredUserCode");
            return "requestUserCode";
        }
        if (dc.isApproved()) {
            model.addAttribute("error", (Object)"userCodeAlreadyApproved");
            return "requestUserCode";
        }
        ClientDetailsEntity client = this.clientService.loadClientByClientId(dc.getClientId());
        model.put((Object)"client", (Object)client);
        model.put((Object)"dc", (Object)dc);
        Set scopes = this.scopeService.fromStrings(dc.getScope());
        LinkedHashSet<SystemScope> sortedScopes = new LinkedHashSet<SystemScope>(scopes.size());
        Set systemScopes = this.scopeService.getAll();
        for (SystemScope s : systemScopes) {
            if (!scopes.contains(s)) continue;
            sortedScopes.add(s);
        }
        sortedScopes.addAll((Collection<SystemScope>)Sets.difference((Set)scopes, (Set)systemScopes));
        model.put((Object)"scopes", sortedScopes);
        AuthorizationRequest authorizationRequest = this.oAuth2RequestFactory.createAuthorizationRequest(dc.getRequestParameters());
        session.setAttribute("authorizationRequest", (Object)authorizationRequest);
        session.setAttribute("deviceCode", (Object)dc);
        return "approveDevice";
    }

    @PreAuthorize(value="hasRole('ROLE_USER')")
    @RequestMapping(value={"/device/approve"}, method={RequestMethod.POST})
    public String approveDevice(@RequestParam(value="user_code") String userCode, @RequestParam(value="user_oauth_approval") Boolean approve, ModelMap model, Authentication auth, HttpSession session) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)session.getAttribute("authorizationRequest");
        DeviceCode dc = (DeviceCode)session.getAttribute("deviceCode");
        if (!dc.getUserCode().equals(userCode)) {
            model.addAttribute("error", (Object)"userCodeMismatch");
            return "requestUserCode";
        }
        if (dc.getExpiration() != null && dc.getExpiration().before(new Date())) {
            model.addAttribute("error", (Object)"expiredUserCode");
            return "requestUserCode";
        }
        ClientDetailsEntity client = this.clientService.loadClientByClientId(dc.getClientId());
        model.put((Object)"client", (Object)client);
        if (!approve.booleanValue()) {
            model.addAttribute("approved", (Object)false);
            return "deviceApproved";
        }
        OAuth2Request o2req = this.oAuth2RequestFactory.createOAuth2Request(authorizationRequest);
        OAuth2Authentication o2Auth = new OAuth2Authentication(o2req, auth);
        DeviceCode approvedCode = this.deviceCodeService.approveDeviceCode(dc, o2Auth);
        Set scopes = this.scopeService.fromStrings(dc.getScope());
        LinkedHashSet<SystemScope> sortedScopes = new LinkedHashSet<SystemScope>(scopes.size());
        Set systemScopes = this.scopeService.getAll();
        for (SystemScope s : systemScopes) {
            if (!scopes.contains(s)) continue;
            sortedScopes.add(s);
        }
        sortedScopes.addAll((Collection<SystemScope>)Sets.difference((Set)scopes, (Set)systemScopes));
        model.put((Object)"scopes", sortedScopes);
        model.put((Object)"approved", (Object)true);
        return "deviceApproved";
    }
}

