/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.jwt.encryption.service.JWTEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.ClientKeyCacheService;
import org.mitre.jwt.signer.service.impl.SymmetricKeyJWTValidatorCacheService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.view.UserInfoView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component(value="userInfoJwtView")
public class UserInfoJWTView
extends UserInfoView {
    public static final String CLIENT = "client";
    private static final Logger logger = LoggerFactory.getLogger(UserInfoJWTView.class);
    public static final String VIEWNAME = "userInfoJwtView";
    public static final String JOSE_MEDIA_TYPE_VALUE = "application/jwt";
    public static final MediaType JOSE_MEDIA_TYPE = new MediaType("application", "jwt");
    @Autowired
    private JWTSigningAndValidationService jwtService;
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private ClientKeyCacheService encrypters;
    @Autowired
    private SymmetricKeyJWTValidatorCacheService symmetricCacheService;

    @Override
    protected void writeOut(JsonObject json, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        try {
            ClientDetailsEntity client = (ClientDetailsEntity)model.get(CLIENT);
            StringWriter writer = new StringWriter();
            this.gson.toJson((JsonElement)json, (Appendable)writer);
            response.setContentType(JOSE_MEDIA_TYPE_VALUE);
            JWTClaimsSet claims = new JWTClaimsSet.Builder(JWTClaimsSet.parse((String)writer.toString())).audience((List)Lists.newArrayList((Object[])new String[]{client.getClientId()})).issuer(this.config.getIssuer()).issueTime(new Date()).jwtID(UUID.randomUUID().toString()).build();
            if (!(client.getUserInfoEncryptedResponseAlg() == null || client.getUserInfoEncryptedResponseAlg().equals((Object)Algorithm.NONE) || client.getUserInfoEncryptedResponseEnc() == null || client.getUserInfoEncryptedResponseEnc().equals((Object)Algorithm.NONE) || Strings.isNullOrEmpty((String)client.getJwksUri()) && client.getJwks() == null)) {
                JWTEncryptionAndDecryptionService encrypter = this.encrypters.getEncrypter(client);
                if (encrypter != null) {
                    EncryptedJWT encrypted = new EncryptedJWT(new JWEHeader(client.getUserInfoEncryptedResponseAlg(), client.getUserInfoEncryptedResponseEnc()), claims);
                    encrypter.encryptJwt((JWEObject)encrypted);
                    PrintWriter out = response.getWriter();
                    ((Writer)out).write(encrypted.serialize());
                } else {
                    logger.error("Couldn't find encrypter for client: " + client.getClientId());
                }
            } else {
                JWSAlgorithm signingAlg = this.jwtService.getDefaultSigningAlgorithm();
                if (client.getUserInfoSignedResponseAlg() != null) {
                    signingAlg = client.getUserInfoSignedResponseAlg();
                }
                JWSHeader header = new JWSHeader(signingAlg, null, null, null, null, null, null, null, null, null, this.jwtService.getDefaultSignerKeyId(), null, null);
                SignedJWT signed = new SignedJWT(header, claims);
                if (signingAlg.equals((Object)JWSAlgorithm.HS256) || signingAlg.equals((Object)JWSAlgorithm.HS384) || signingAlg.equals((Object)JWSAlgorithm.HS512)) {
                    JWTSigningAndValidationService signer = this.symmetricCacheService.getSymmetricValidtor(client);
                    signer.signJwt(signed);
                } else {
                    this.jwtService.signJwt(signed);
                }
                PrintWriter out = response.getWriter();
                ((Writer)out).write(signed.serialize());
            }
        }
        catch (IOException e) {
            logger.error("IO Exception in UserInfoJwtView", (Throwable)e);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

