/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mortbay.jetty.plus.annotation.LifeCycleCallback;
import org.mortbay.jetty.plus.annotation.PojoWrapper;
import org.mortbay.jetty.plus.annotation.PostConstructCallback;
import org.mortbay.jetty.plus.annotation.PreDestroyCallback;
import org.mortbay.log.Log;

public class LifeCycleCallbackCollection {
    private HashMap postConstructCallbacksMap = new HashMap();
    private HashMap preDestroyCallbacksMap = new HashMap();

    public void add(LifeCycleCallback callback) {
        if (callback == null || callback.getTargetClass() == null || callback.getTarget() == null) {
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Adding callback for class=" + callback.getTargetClass() + " on " + callback.getTarget()));
        }
        HashMap map = null;
        if (callback instanceof PreDestroyCallback) {
            map = this.preDestroyCallbacksMap;
        }
        if (callback instanceof PostConstructCallback) {
            map = this.postConstructCallbacksMap;
        }
        if (map == null) {
            throw new IllegalArgumentException("Unsupported lifecycle callback type: " + callback);
        }
        ArrayList<LifeCycleCallback> callbacks = (ArrayList<LifeCycleCallback>)map.get(callback.getTargetClass());
        if (callbacks == null) {
            callbacks = new ArrayList<LifeCycleCallback>();
            map.put(callback.getTargetClass(), callbacks);
        }
        if (!callbacks.contains(callback)) {
            callbacks.add(callback);
        }
    }

    public List getPreDestroyCallbacks(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        if (o instanceof PojoWrapper) {
            o = ((PojoWrapper)o).getPojo();
            clazz = o.getClass();
        }
        return (List)this.preDestroyCallbacksMap.get(clazz);
    }

    public List getPostConstructCallbacks(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        if (o instanceof PojoWrapper) {
            o = ((PojoWrapper)o).getPojo();
            clazz = o.getClass();
        }
        return (List)this.postConstructCallbacksMap.get(clazz);
    }

    public void callPostConstructCallback(Object o) throws Exception {
        List callbacks;
        if (o == null) {
            return;
        }
        Class<?> clazz = o.getClass();
        if (o instanceof PojoWrapper) {
            o = ((PojoWrapper)o).getPojo();
            clazz = o.getClass();
        }
        if ((callbacks = (List)this.postConstructCallbacksMap.get(clazz)) == null) {
            return;
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            ((LifeCycleCallback)callbacks.get(i)).callback(o);
        }
    }

    public void callPreDestroyCallback(Object o) throws Exception {
        List callbacks;
        if (o == null) {
            return;
        }
        Class<?> clazz = o.getClass();
        if (o instanceof PojoWrapper) {
            o = ((PojoWrapper)o).getPojo();
            clazz = o.getClass();
        }
        if ((callbacks = (List)this.preDestroyCallbacksMap.get(clazz)) == null) {
            return;
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            ((LifeCycleCallback)callbacks.get(i)).callback(o);
        }
    }
}

