/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.security;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.plus.naming.NamingEntryUtil;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.log.Log;

public class DataSourceUserRealm
extends HashUserRealm {
    private String _jndiName = "javax.sql.DataSource/default";
    private DataSource _datasource;
    private Server _server;
    private String _userTableName = "users";
    private String _userTableKey = "id";
    private String _userTableUserField = "username";
    private String _userTablePasswordField = "pwd";
    private String _roleTableName = "roles";
    private String _roleTableKey = "id";
    private String _roleTableRoleField = "role";
    private String _userRoleTableName = "user_roles";
    private String _userRoleTableUserKey = "user_id";
    private String _userRoleTableRoleKey = "role_id";
    private int _cacheMs = 30000;
    private long _lastHashPurge = 0L;
    private String _userSql;
    private String _roleSql;

    public DataSourceUserRealm(String jndiName) {
        this._jndiName = jndiName;
    }

    public DataSourceUserRealm() {
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public Server getServer() {
        return this._server;
    }

    public void setUserTableName(String name) {
        this._userTableName = name;
    }

    public String getUserTableName() {
        return this._userTableName;
    }

    public String getUserTableKey() {
        return this._userTableKey;
    }

    public void setUserTableKey(String tableKey) {
        this._userTableKey = tableKey;
    }

    public String getUserTableUserField() {
        return this._userTableUserField;
    }

    public void setUserTableUserField(String tableUserField) {
        this._userTableUserField = tableUserField;
    }

    public String getUserTablePasswordField() {
        return this._userTablePasswordField;
    }

    public void setUserTablePasswordField(String tablePasswordField) {
        this._userTablePasswordField = tablePasswordField;
    }

    public String getRoleTableName() {
        return this._roleTableName;
    }

    public void setRoleTableName(String tableName) {
        this._roleTableName = tableName;
    }

    public String getRoleTableKey() {
        return this._roleTableKey;
    }

    public void setRoleTableKey(String tableKey) {
        this._roleTableKey = tableKey;
    }

    public String getRoleTableRoleField() {
        return this._roleTableRoleField;
    }

    public void setRoleTableRoleField(String tableRoleField) {
        this._roleTableRoleField = tableRoleField;
    }

    public String getUserRoleTableName() {
        return this._userRoleTableName;
    }

    public void setUserRoleTableName(String roleTableName) {
        this._userRoleTableName = roleTableName;
    }

    public String getUserRoleTableUserKey() {
        return this._userRoleTableUserKey;
    }

    public void setUserRoleTableUserKey(String roleTableUserKey) {
        this._userRoleTableUserKey = roleTableUserKey;
    }

    public String getUserRoleTableRoleKey() {
        return this._userRoleTableRoleKey;
    }

    public void setUserRoleTableRoleKey(String roleTableRoleKey) {
        this._userRoleTableRoleKey = roleTableRoleKey;
    }

    public void setCacheMs(int ms) {
        this._cacheMs = ms;
    }

    public int getCacheMs() {
        return this._cacheMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String username, Object credentials, Request request) {
        DataSourceUserRealm dataSourceUserRealm = this;
        synchronized (dataSourceUserRealm) {
            Principal user;
            long now = System.currentTimeMillis();
            if (now - this._lastHashPurge > (long)this._cacheMs || this._cacheMs == 0) {
                this._users.clear();
                this._roles.clear();
                this._lastHashPurge = now;
            }
            if ((user = super.getPrincipal(username)) == null) {
                this.loadUser(username);
                user = super.getPrincipal(username);
            }
        }
        return super.authenticate(username, credentials, request);
    }

    public synchronized boolean isUserInRole(Principal user, String roleName) {
        if (super.getPrincipal(user.getName()) == null) {
            this.loadUser(user.getName());
        }
        return super.isUserInRole(user, roleName);
    }

    protected void loadConfig() throws IOException {
        Properties properties = new Properties();
        properties.load(this.getConfigResource().getInputStream());
        this._jndiName = properties.getProperty("jndiname");
        this.setUserTableName(properties.getProperty("usertable"));
        this.setUserTableKey(properties.getProperty("usertablekey"));
        this.setUserTableUserField(properties.getProperty("usertableuserfield"));
        this.setUserTablePasswordField(properties.getProperty("usertablepasswordfield"));
        this.setRoleTableName(properties.getProperty("roletable"));
        this.setRoleTableKey(properties.getProperty("roletablekey"));
        this.setRoleTableRoleField(properties.getProperty("roletablerolefield"));
        this.setUserRoleTableName(properties.getProperty("userroletable"));
        this.setUserRoleTableUserKey(properties.getProperty("userroletableuserkey"));
        this.setUserRoleTableRoleKey(properties.getProperty("userroletablerolekey"));
        String cacheSec = properties.getProperty("cachetime");
        if (cacheSec != null) {
            this.setCacheMs(new Integer(cacheSec) * 1000);
        }
        if ((this._jndiName == null || this._cacheMs < 0) && Log.isDebugEnabled()) {
            Log.debug((String)("UserRealm " + this.getName() + " has not been properly configured"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadUser(String user) {
        Connection connection = null;
        try {
            this.initDb();
            connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement(this._userSql);
            statement.setObject(1, user);
            ResultSet rs = statement.executeQuery();
            if (!rs.next()) return;
            int key = rs.getInt(this._userTableKey);
            this.put(user, rs.getString(this._userTablePasswordField));
            statement.close();
            statement = connection.prepareStatement(this._roleSql);
            statement.setInt(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                this.addUserToRole(user, rs.getString(this._roleTableRoleField));
            }
            statement.close();
            return;
        }
        catch (NamingException e) {
            Log.warn((String)("No datasource for " + this._jndiName), (Throwable)e);
            return;
        }
        catch (SQLException e) {
            Log.warn((String)("Problem loading user info for " + user), (Throwable)e);
            return;
        }
        finally {
            if (connection != null) {
                try {
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (SQLException x) {
                        Log.warn((String)"Problem closing connection", (Throwable)x);
                        connection = null;
                    }
                }
                catch (Throwable throwable) {
                    connection = null;
                    throw throwable;
                }
            }
        }
    }

    private void initDb() throws NamingException {
        if (this._datasource != null) {
            return;
        }
        InitialContext ic = new InitialContext();
        try {
            this._datasource = (DataSource)NamingEntryUtil.lookup(this._server, this._jndiName);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (this._datasource == null) {
            this._datasource = (DataSource)NamingEntryUtil.lookup(null, this._jndiName);
        }
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + this._userTableName + " where " + this._userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + this._roleTableName + " r, " + this._userRoleTableName + " u where u." + this._userRoleTableUserKey + " = ?" + " and r." + this._roleTableKey + " = u." + this._userRoleTableRoleKey;
    }

    private Connection getConnection() throws NamingException, SQLException {
        this.initDb();
        return this._datasource.getConnection();
    }
}

