/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;

public class NextProtocolMessage
extends HandshakeMessage {
    public static final int ID = 67;
    private final byte[] protocolBytes;
    private final byte[] paddingBytes;
    private final String protocol;

    public NextProtocolMessage(String protocol) {
        this.protocolBytes = protocol == null ? new byte[]{} : protocol.getBytes(StandardCharsets.UTF_8);
        this.paddingBytes = new byte[32 - (1 + this.protocolBytes.length + 1) % 32];
        this.protocol = protocol;
    }

    public NextProtocolMessage(HandshakeInStream input) throws IOException {
        this.protocolBytes = input.getBytes8();
        this.paddingBytes = input.getBytes8();
        this.protocol = this.protocolBytes.length == 0 ? null : new String(this.protocolBytes, StandardCharsets.UTF_8);
    }

    public String getProtocol() {
        return this.protocol;
    }

    int messageType() {
        return 67;
    }

    int messageLength() {
        return 1 + this.protocolBytes.length + 1 + this.paddingBytes.length;
    }

    void send(HandshakeOutStream output) throws IOException {
        output.putBytes8(this.protocolBytes);
        output.putBytes8(this.paddingBytes);
    }

    void print(PrintStream stream) throws IOException {
        stream.printf("*** NextProtocol(%s)%n", this.protocol);
    }
}

