/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.inject.Injector;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import ninja.standalone.NinjaJetty;
import ninja.utils.NinjaMode;
import org.apache.http.client.utils.URIBuilder;

public class NinjaTestServer {
    private final int port = NinjaTestServer.findAvailablePort(1000, 10000);
    private final URI serverUri = this.createServerUri();
    private final NinjaJetty ninjaJetty = new NinjaJetty();

    public NinjaTestServer() {
        this.ninjaJetty.setPort(this.port);
        this.ninjaJetty.setServerUri(this.serverUri);
        this.ninjaJetty.setNinjaMode(NinjaMode.test);
        this.ninjaJetty.start();
    }

    public Injector getInjector() {
        return this.ninjaJetty.getInjector();
    }

    public String getServerAddress() {
        return this.serverUri.toString() + "/";
    }

    public URI getServerAddressAsUri() {
        return this.serverUri;
    }

    private URI createServerUri() {
        try {
            return new URIBuilder().setScheme("http").setHost("localhost").setPort(this.port).build();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void shutdown() {
        this.ninjaJetty.shutdown();
    }

    private static int findAvailablePort(int min, int max) {
        for (int port = min; port < max; ++port) {
            try {
                new ServerSocket(port).close();
                return port;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new IllegalStateException("Could not find available port in range " + min + " to " + max);
    }
}

