/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import org.openimaj.feature.ByteFVComparator;
import org.openimaj.feature.ByteFVComparison;
import org.openimaj.knn.ByteNearestNeighbours;
import org.openimaj.knn.ByteNearestNeighboursExact;
import org.openimaj.knn.ByteNearestNeighboursProvider;
import org.openimaj.knn.approximate.ByteNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.util.pair.IndependentPair;

public class ByteKNNAssigner
implements SoftAssigner<byte[], float[]> {
    protected ByteNearestNeighbours nn;
    protected int numNeighbours;

    public ByteKNNAssigner(CentroidsProvider<byte[]> provider, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        if (exact) {
            this.nn = new ByteNearestNeighboursExact((byte[][])provider.getCentroids());
        } else {
            ByteNearestNeighbours internal;
            if (provider instanceof ByteNearestNeighboursProvider && (internal = ((ByteNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof ByteNearestNeighboursKDTree) {
                this.nn = (ByteNearestNeighboursKDTree)internal;
                return;
            }
            this.nn = new ByteNearestNeighboursKDTree((byte[][])provider.getCentroids(), 8, 768);
        }
    }

    public ByteKNNAssigner(byte[][] data, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = exact ? new ByteNearestNeighboursExact(data) : new ByteNearestNeighboursKDTree(data, 8, 768);
    }

    public ByteKNNAssigner(CentroidsProvider<byte[]> provider, ByteFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new ByteNearestNeighboursExact((byte[][])provider.getCentroids(), (ByteFVComparator)comparison);
    }

    public ByteKNNAssigner(byte[][] data, ByteFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new ByteNearestNeighboursExact(data, (ByteFVComparator)comparison);
    }

    public int[][] assign(byte[][] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        float[][] distances = new float[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])data, this.numNeighbours, indices, (Object[])distances);
        return indices;
    }

    @Override
    public int[] assign(byte[] data) {
        return this.assign(new byte[][]{data})[0];
    }

    public void assignWeighted(byte[][] data, int[][] assignments, float[][] weights) {
        this.nn.searchKNN((Object[])data, this.numNeighbours, assignments, (Object[])weights);
    }

    @Override
    public IndependentPair<int[], float[]> assignWeighted(byte[] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        float[][] distances = new float[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])new byte[][]{data}, this.numNeighbours, indices, (Object[])distances);
        return new IndependentPair((Object)indices[0], (Object)distances[0]);
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }
}

