/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactIntAssigner;
import org.openimaj.ml.clustering.kmeans.HierarchicalIntKMeansResult;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.IntFloatPair;

public class HierarchicalIntPathAssigner
implements SoftAssigner<int[], float[]> {
    protected HierarchicalIntKMeansResult result;
    protected Map<CentroidsProvider<int[]>, HardAssigner<int[], float[], IntFloatPair>> assigners;

    public HierarchicalIntPathAssigner(HierarchicalIntKMeansResult result) {
        this.result = result;
        this.assigners = new HashMap<CentroidsProvider<int[]>, HardAssigner<int[], float[], IntFloatPair>>();
    }

    public int[][] assign(int[][] data) {
        int[][] assignments = new int[data.length][this.result.getDepth()];
        block0: for (int i = 0; i < data.length; ++i) {
            HierarchicalIntKMeansResult.Node node = this.result.getRoot();
            int d = 0;
            while (node != null) {
                int best;
                ExactIntAssigner assigner = this.assigners.get(node.result);
                if (assigner == null) {
                    assigner = new ExactIntAssigner(node.result);
                    this.assigners.put(node.result, assigner);
                }
                assignments[i][d] = best = assigner.assign((int[])data[i]);
                ++d;
                if (node.children == null) continue block0;
                node = node.children[best];
            }
        }
        return assignments;
    }

    @Override
    public int[] assign(int[] data) {
        return this.assign(new int[][]{data})[0];
    }

    public void assignWeighted(int[][] data, int[][] assignments, float[][] weights) {
        int depth = this.result.getDepth();
        block0: for (int i = 0; i < data.length; ++i) {
            HierarchicalIntKMeansResult.Node node = this.result.getRoot();
            if (assignments[i].length != depth) {
                assignments[i] = new int[depth];
            }
            Arrays.fill((Object[])assignments, (Object)-1);
            if (weights[i].length != depth) {
                weights[i] = new float[depth];
            }
            int d = 0;
            while (node != null) {
                ExactIntAssigner assigner = this.assigners.get(node.result);
                if (assigner == null) {
                    assigner = new ExactIntAssigner(node.result);
                    this.assigners.put(node.result, assigner);
                }
                IntFloatPair best = assigner.assignDistance((int[])data[i]);
                assignments[i][d] = best.first;
                weights[i][d] = best.second;
                ++d;
                if (node.children == null) continue block0;
                node = node.children[best.first];
            }
        }
    }

    @Override
    public IndependentPair<int[], float[]> assignWeighted(int[] data) {
        int[][] assignments = new int[1][];
        float[][] weights = new float[1][];
        this.assignWeighted(new int[][]{data}, (int[][])assignments, weights);
        return new IndependentPair((Object)assignments[0], (Object)weights[0]);
    }

    @Override
    public int numDimensions() {
        return this.result.numDimensions();
    }
}

