/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.rac;

import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.openimaj.ml.clustering.rac.IntRAC;

public class ClusterLimitedIntRAC
extends IntRAC {
    private int expectedClusters;
    private SortedMap<Float, Integer> thresholdOvershots;

    public ClusterLimitedIntRAC() {
        this.expectedClusters = 100;
        this.thresholdOvershots = new TreeMap<Float, Integer>();
    }

    public ClusterLimitedIntRAC(double radiusSquared) {
        super(radiusSquared);
        this.expectedClusters = 100;
        this.thresholdOvershots = new TreeMap<Float, Integer>();
    }

    public ClusterLimitedIntRAC(int[][] bKeys, int subSamples, int nClusters) {
        super(bKeys, subSamples, nClusters);
        this.expectedClusters = (int)((float)nClusters / (float)subSamples * (float)bKeys.length);
    }

    @Override
    public ClusterLimitedIntRAC cluster(int[][] data) {
        int foundLength = this.nDims;
        for (int[] entry : data) {
            if (foundLength == -1) {
                foundLength = entry.length;
            }
            if (foundLength != entry.length) {
                throw new RuntimeException();
            }
            boolean found = false;
            float minDiff = 0.0f;
            for (int[] existing : this.codebook) {
                float distance = ClusterLimitedIntRAC.distanceEuclidianSquared(entry, existing);
                if ((double)distance < this.threshold) {
                    found = true;
                    break;
                }
                distance = (float)((double)distance - this.threshold);
                if (minDiff != 0.0f && !(distance < minDiff)) continue;
                minDiff = distance;
            }
            if (!found) {
                if (this.numClusters() >= this.expectedClusters) {
                    Float smallestDistance = this.thresholdOvershots.firstKey();
                    if (smallestDistance.floatValue() < minDiff) {
                        Integer index = (Integer)this.thresholdOvershots.get(smallestDistance);
                        this.codebook.remove(index);
                        this.codebook.add(index, entry);
                        this.thresholdOvershots.remove(smallestDistance);
                        this.thresholdOvershots.put(Float.valueOf(minDiff), this.numClusters() - 1);
                    }
                } else {
                    this.codebook.add(entry);
                    if (this.numClusters() % 1000 == 0) {
                        System.out.println("Codebook increased to size " + this.numClusters());
                        System.out.println("with nSamples = " + this.totalSamples);
                    }
                    this.thresholdOvershots.put(Float.valueOf(minDiff), this.numClusters() - 1);
                }
            }
            ++this.totalSamples;
        }
        this.nDims = foundLength;
        return this;
    }

    static class ClusterMinimisationFunction
    implements UnivariateRealFunction {
        private int[][] distances;
        private int[][] samples;
        private int nClusters;

        public ClusterMinimisationFunction(int[][] samples, int[][] distances, int nClusters) {
            this.distances = distances;
            this.samples = samples;
            this.nClusters = nClusters;
        }

        public double value(double radius) throws FunctionEvaluationException {
            ClusterLimitedIntRAC r = new ClusterLimitedIntRAC(radius);
            r.train(this.samples, this.distances);
            int diff = this.nClusters - r.numClusters();
            return diff;
        }
    }
}

