/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.random;

import java.util.Arrays;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.ml.clustering.DoubleCentroidsResult;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;

public class RandomDoubleClusterer
implements SpatialClusterer<DoubleCentroidsResult, double[]> {
    protected int M;
    protected int K;
    protected Random random;
    protected long seed;

    public RandomDoubleClusterer(int M, int K) {
        this.M = M;
        this.K = K;
        this.random = new Random();
        this.seed = -1L;
    }

    public RandomDoubleClusterer(int M) {
        this(M, -1);
    }

    public void setSeed(long seed) {
        this.random = new Random();
        this.random.setSeed(seed);
        this.seed = seed;
    }

    public DoubleCentroidsResult cluster(double[][] data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.length;
        }
        DoubleCentroidsResult result = new DoubleCentroidsResult();
        result.centroids = new double[nc][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.length);
            result.centroids[i] = Arrays.copyOf(data[dIndex], data[dIndex].length);
        }
        return result;
    }

    public int[][] performClustering(double[][] data) {
        DoubleCentroidsResult res = this.cluster(data);
        return new IndexClusters(res.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    @Override
    public DoubleCentroidsResult cluster(DataSource<double[]> data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.numRows();
        }
        DoubleCentroidsResult result = new DoubleCentroidsResult();
        result.centroids = new double[nc][this.M];
        double[][] dataRow = new double[1][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.numRows());
            dataRow[0] = result.centroids[i];
            data.getData(dIndex, dIndex + 1, (Object[])dataRow);
        }
        return result;
    }
}

