/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.options.BootClasspathLibraryOption;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.BundleStartLevelOption;
import org.ops4j.pax.exam.options.CompositeOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.FrameworkPropertyOption;
import org.ops4j.pax.exam.options.FrameworkStartLevelOption;
import org.ops4j.pax.exam.options.JarProbeOption;
import org.ops4j.pax.exam.options.MavenArtifactDeploymentOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.OptionalCompositeOption;
import org.ops4j.pax.exam.options.PropagateSystemPropertyOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.ServerModeOption;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.TimeoutOption;
import org.ops4j.pax.exam.options.UrlDeploymentOption;
import org.ops4j.pax.exam.options.UrlProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.WarProbeOption;
import org.ops4j.pax.exam.options.WrappedUrlProvisionOption;
import org.ops4j.pax.exam.options.extra.CleanCachesOption;
import org.ops4j.pax.exam.options.extra.RepositoryOption;
import org.ops4j.pax.exam.options.extra.RepositoryOptionImpl;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.ops4j.pax.exam.options.extra.WorkingDirectoryOption;
import org.ops4j.pax.exam.options.libraries.JUnitBundlesOption;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;
import org.ops4j.store.StoreFactory;

public class CoreOptions {
    private CoreOptions() {
    }

    public static Option[] options(Option ... options) {
        return OptionUtils.expand(options);
    }

    public static Option composite(Option ... options) {
        return new DefaultCompositeOption(options);
    }

    public static Option provision(String ... urls) {
        NullArgumentException.validateNotEmptyContent((String[])urls, (boolean)true, (String)"URLs");
        ArrayList<UrlProvisionOption> options = new ArrayList<UrlProvisionOption>();
        for (String url : urls) {
            options.add(new UrlProvisionOption(url));
        }
        return CoreOptions.provision(options.toArray(new ProvisionOption[options.size()]));
    }

    public static Option provision(InputStream ... streams) {
        NullArgumentException.validateNotNull((Object)streams, (String)"streams");
        UrlProvisionOption[] options = new UrlProvisionOption[streams.length];
        int i = 0;
        for (InputStream stream : streams) {
            options[i++] = CoreOptions.streamBundle(stream);
        }
        return CoreOptions.provision(options);
    }

    public static Option provision(ProvisionOption<?> ... urls) {
        return CoreOptions.composite(urls);
    }

    public static UrlProvisionOption streamBundle(InputStream stream) {
        NullArgumentException.validateNotNull((Object)stream, (String)"stream");
        try {
            Store store = StoreFactory.anonymousStore();
            Handle handle = store.store((Object)stream);
            URL url = store.getLocation(handle).toURL();
            UrlProvisionOption option = new UrlProvisionOption(url.toExternalForm());
            return option;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("A supplied stream blew up", e);
        }
    }

    public static UrlProvisionOption url(String url) {
        return new UrlProvisionOption(url);
    }

    public static UrlProvisionOption bundle(String url) {
        return new UrlProvisionOption(url);
    }

    public static MavenArtifactUrlReference maven() {
        return new MavenArtifactUrlReference();
    }

    public static MavenArtifactUrlReference maven(String groupId, String artifactId) {
        return CoreOptions.maven().groupId(groupId).artifactId(artifactId);
    }

    public static MavenArtifactUrlReference maven(String groupId, String artifactId, String version) {
        return CoreOptions.maven().groupId(groupId).artifactId(artifactId).version(version);
    }

    public static MavenArtifactProvisionOption mavenBundle() {
        return new MavenArtifactProvisionOption();
    }

    public static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId) {
        return CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId);
    }

    public static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId, String version) {
        return CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId).version(version);
    }

    public static MavenArtifactProvisionOption mavenBundle(MavenArtifactUrlReference artifact) {
        return new MavenArtifactProvisionOption(artifact);
    }

    public static WrappedUrlProvisionOption wrappedBundle(String jarToWrapUrl) {
        return new WrappedUrlProvisionOption(jarToWrapUrl);
    }

    public static WrappedUrlProvisionOption wrappedBundle(UrlReference jarToWrapUrl) {
        return new WrappedUrlProvisionOption(jarToWrapUrl);
    }

    public static Option bootDelegationPackages(String ... packages) {
        NullArgumentException.validateNotEmptyContent((String[])packages, (boolean)true, (String)"Packages");
        ArrayList<BootDelegationOption> options = new ArrayList<BootDelegationOption>();
        for (String pkg : packages) {
            options.add(CoreOptions.bootDelegationPackage(pkg));
        }
        return CoreOptions.bootDelegationPackages(options.toArray(new BootDelegationOption[options.size()]));
    }

    public static Option bootDelegationPackages(BootDelegationOption ... packages) {
        return CoreOptions.composite(packages);
    }

    public static BootDelegationOption bootDelegationPackage(String pkg) {
        return new BootDelegationOption(pkg);
    }

    public static Option bootClasspathLibraries(String ... urls) {
        NullArgumentException.validateNotEmptyContent((String[])urls, (boolean)true, (String)"Urls");
        ArrayList<BootClasspathLibraryOption> options = new ArrayList<BootClasspathLibraryOption>();
        for (String url : urls) {
            options.add(CoreOptions.bootClasspathLibrary(url));
        }
        return CoreOptions.bootClasspathLibraries(options.toArray(new BootClasspathLibraryOption[options.size()]));
    }

    public static Option bootClasspathLibraries(BootClasspathLibraryOption ... libraries) {
        return CoreOptions.composite(libraries);
    }

    public static BootClasspathLibraryOption bootClasspathLibrary(String libraryUrl) {
        return new BootClasspathLibraryOption(libraryUrl);
    }

    public static BootClasspathLibraryOption bootClasspathLibrary(UrlReference libraryUrl) {
        return new BootClasspathLibraryOption(libraryUrl);
    }

    public static Option systemPackages(String ... packages) {
        NullArgumentException.validateNotEmptyContent((String[])packages, (boolean)true, (String)"Packages");
        ArrayList<SystemPackageOption> options = new ArrayList<SystemPackageOption>();
        for (String pkg : packages) {
            options.add(CoreOptions.systemPackage(pkg));
        }
        return CoreOptions.systemPackages(options.toArray(new SystemPackageOption[options.size()]));
    }

    public static Option systemPackages(SystemPackageOption ... packages) {
        return CoreOptions.composite(packages);
    }

    public static SystemPackageOption systemPackage(String pkg) {
        return new SystemPackageOption(pkg);
    }

    public static Option systemProperties(SystemPropertyOption ... systemProperties) {
        return CoreOptions.composite(systemProperties);
    }

    public static SystemPropertyOption systemProperty(String key) {
        return new SystemPropertyOption(key);
    }

    public static PropagateSystemPropertyOption propagateSystemProperty(String key) {
        return new PropagateSystemPropertyOption(key);
    }

    public static Option propagateSystemProperties(String ... keys) {
        ArrayList<PropagateSystemPropertyOption> options = new ArrayList<PropagateSystemPropertyOption>();
        for (String key : keys) {
            options.add(CoreOptions.propagateSystemProperty(key));
        }
        return CoreOptions.composite(options.toArray(new Option[options.size()]));
    }

    public static FrameworkPropertyOption frameworkProperty(String key) {
        return new FrameworkPropertyOption(key);
    }

    public static Option frameworkProperties(FrameworkPropertyOption ... frameworkProperties) {
        return CoreOptions.composite(frameworkProperties);
    }

    public static OptionalCompositeOption when(boolean condition) {
        return new OptionalCompositeOption(condition);
    }

    public static OptionalCompositeOption when(OptionalCompositeOption.Condition condition) {
        return new OptionalCompositeOption(condition);
    }

    public static FrameworkStartLevelOption frameworkStartLevel(int startLevel) {
        return new FrameworkStartLevelOption(startLevel);
    }

    public static BundleStartLevelOption bundleStartLevel(int startLevel) {
        return new BundleStartLevelOption(startLevel);
    }

    public static TimeoutOption systemTimeout(long timeoutInMillis) {
        return new TimeoutOption(timeoutInMillis);
    }

    public static CompositeOption junitBundles() {
        return new DefaultCompositeOption(new JUnitBundlesOption(), CoreOptions.systemProperty("pax.exam.invoker").value("junit"), CoreOptions.bundle("link:classpath:META-INF/links/org.ops4j.pax.tipi.hamcrest.core.link"), CoreOptions.bundle("link:classpath:META-INF/links/org.ops4j.pax.exam.invoker.junit.link"));
    }

    public static CleanCachesOption cleanCaches(boolean value) {
        return new CleanCachesOption(value);
    }

    public static CleanCachesOption cleanCaches() {
        return new CleanCachesOption();
    }

    public static CleanCachesOption keepCaches() {
        return new CleanCachesOption(Boolean.FALSE);
    }

    public static Option serverMode() {
        return CoreOptions.composite(CoreOptions.keepCaches(), new ServerModeOption());
    }

    public static Option vmOptions(String ... vmOptions) {
        NullArgumentException.validateNotEmptyContent((String[])vmOptions, (boolean)true, (String)"VM options");
        ArrayList<VMOption> options = new ArrayList<VMOption>();
        for (String vmOption : vmOptions) {
            options.add(CoreOptions.vmOption(vmOption));
        }
        return CoreOptions.vmOptions(options.toArray(new VMOption[options.size()]));
    }

    public static Option vmOptions(VMOption ... vmOptions) {
        return new DefaultCompositeOption(vmOptions);
    }

    public static VMOption vmOption(String vmOption) {
        return new VMOption(vmOption);
    }

    public static Option repositories(String ... repositoryUrls) {
        NullArgumentException.validateNotEmptyContent((String[])repositoryUrls, (boolean)true, (String)"Repository URLs");
        ArrayList<RepositoryOption> options = new ArrayList<RepositoryOption>();
        for (String repositoryUrl : repositoryUrls) {
            options.add(CoreOptions.repository(repositoryUrl));
        }
        return CoreOptions.repositories(options.toArray(new RepositoryOption[options.size()]));
    }

    public static Option repositories(RepositoryOption ... repositoryOptions) {
        return new DefaultCompositeOption(repositoryOptions);
    }

    public static RepositoryOption repository(String repositoryUrl) {
        return new RepositoryOptionImpl(repositoryUrl);
    }

    public static WorkingDirectoryOption workingDirectory(String directory) {
        return new WorkingDirectoryOption(directory);
    }

    public static UrlDeploymentOption war(String url) {
        return new UrlDeploymentOption(url, "war");
    }

    public static UrlDeploymentOption jar(String url) {
        return new UrlDeploymentOption(url, "jar");
    }

    public static UrlDeploymentOption rar(String url) {
        return new UrlDeploymentOption(url, "rar");
    }

    public static MavenArtifactDeploymentOption mavenWar() {
        return new MavenArtifactDeploymentOption().type("war");
    }

    public static MavenArtifactDeploymentOption mavenWar(String groupId, String artifactId, String version) {
        return CoreOptions.mavenWar().groupId(groupId).artifactId(artifactId).version(version).type("war");
    }

    public static MavenArtifactDeploymentOption mavenJar(String groupId, String artifactId, String version) {
        return CoreOptions.mavenWar().groupId(groupId).artifactId(artifactId).version(version).type("jar");
    }

    public static MavenArtifactDeploymentOption mavenRar(String groupId, String artifactId, String version) {
        return CoreOptions.mavenWar().groupId(groupId).artifactId(artifactId).version(version).type("rar");
    }

    public static WarProbeOption warProbe() {
        return new WarProbeOption();
    }

    public static JarProbeOption jarProbe() {
        return new JarProbeOption();
    }
}

