/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.rapidoid.RapidoidThing;
import org.rapidoid.activity.RapidoidThreadFactory;
import org.rapidoid.cache.CacheAtom;
import org.rapidoid.cache.CacheDSL;
import org.rapidoid.cache.impl.CacheStats;
import org.rapidoid.cache.impl.ConcurrentCacheAtomWithStats;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;
import org.rapidoid.util.LazyInit;

public class Caching
extends RapidoidThing {
    private static final LazyInit<ScheduledThreadPoolExecutor> scheduler = new LazyInit<ScheduledThreadPoolExecutor>(new Callable<ScheduledThreadPoolExecutor>(){

        @Override
        public ScheduledThreadPoolExecutor call() throws Exception {
            return new ScheduledThreadPoolExecutor(1, new RapidoidThreadFactory("cache-scheduler", true));
        }
    });

    public static <K, V> CacheDSL<K, V> of(Mapper<K, V> of) {
        return new CacheDSL<K, V>().loader(of);
    }

    public static <K, V> CacheDSL<K, V> of(Class<K> keyClass, Class<V> valueClass) {
        return new CacheDSL();
    }

    public static <K, V> CacheAtom<V> atom(K key, Mapper<K, V> loader, long ttlInMs) {
        return new ConcurrentCacheAtomWithStats<K, V>(key, loader, ttlInMs, new CacheStats());
    }

    public static ScheduledThreadPoolExecutor scheduler() {
        return scheduler.get();
    }

    public static void reset() {
        scheduler.reset();
    }

    public static void shutdown() {
        ScheduledThreadPoolExecutor scheduler = Caching.scheduler();
        scheduler.shutdownNow();
        while (!scheduler.isTerminated()) {
            U.sleep((long)1L);
        }
    }
}

