/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cache.impl;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.rapidoid.cache.Cache;
import org.rapidoid.cache.Caching;
import org.rapidoid.cache.impl.CacheStats;
import org.rapidoid.cache.impl.ConcurrentCacheAtom;
import org.rapidoid.cache.impl.ConcurrentCacheAtomWithStats;
import org.rapidoid.cache.impl.L1CacheSegment;
import org.rapidoid.cache.impl.ManageableCache;
import org.rapidoid.cache.impl.SimpleCacheTable;
import org.rapidoid.commons.Rnd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.util.AbstractMapImpl;
import org.rapidoid.util.MapEntry;
import org.rapidoid.util.Msc;
import org.rapidoid.util.SimpleBucket;

public class ConcurrentCache<K, V>
extends AbstractMapImpl<K, ConcurrentCacheAtom<K, V>>
implements Cache<K, V> {
    private static final int DESIRED_BUCKET_SIZE = 8;
    private final String name;
    private final int capacity;
    private final Mapper<K, V> loader;
    private final long ttlInMs;
    private final CacheStats stats = new CacheStats();
    private final boolean statistics;
    private final int l1Xor = Rnd.rnd();
    private static final int L1_SEGMENTS = 32;
    private static final int L1_SEGMENT_SIZE = 16;
    private final L1CacheSegment<K, V>[] l1Cache = new L1CacheSegment[32];
    private final int l1BitMask = Msc.bitMask(Msc.log2(32));

    public static <K, V> ConcurrentCache<K, V> create(String name, int capacity, Mapper<K, V> loader, long ttlInMs, ScheduledThreadPoolExecutor scheduler, boolean statistics, boolean manageable) {
        boolean unbounded;
        boolean bl = unbounded = capacity == 0;
        if (unbounded) {
            capacity = 65536;
        }
        return new ConcurrentCache<K, V>(name, capacity, loader, ttlInMs, scheduler, statistics, manageable, unbounded);
    }

    private ConcurrentCache(String name, int capacity, Mapper<K, V> loader, long ttlInMs, ScheduledThreadPoolExecutor scheduler, boolean statistics, boolean manageable, boolean unbounded) {
        super(new SimpleCacheTable(capacity, 8, unbounded));
        for (int i = 0; i < this.l1Cache.length; ++i) {
            this.l1Cache[i] = new L1CacheSegment(16);
        }
        this.name = name;
        this.loader = loader;
        this.ttlInMs = ttlInMs;
        this.statistics = statistics;
        this.scheduleCrawl(ttlInMs, scheduler);
        this.capacity = capacity;
        if (manageable) {
            new ManageableCache(this);
        }
    }

    private void scheduleCrawl(long ttlInMs, ScheduledThreadPoolExecutor scheduler) {
        if (ttlInMs > 0L) {
            if (scheduler == null) {
                scheduler = Caching.scheduler();
            }
            scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConcurrentCache.this.crawl();
                    }
                    catch (Exception e) {
                        Log.error((String)"Error occurred while crawling the cache!", (Throwable)e);
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    private void crawl() {
        SimpleBucket<T>[] buckets;
        for (SimpleBucket bucket : buckets = this.entries.buckets) {
            if (bucket == null) continue;
            for (int i = 0; i < bucket.size(); ++i) {
                ConcurrentCacheAtom cachedCalc;
                MapEntry entry = (MapEntry)((Object)bucket.get(i));
                if (entry == null || (cachedCalc = (ConcurrentCacheAtom)entry.value) == null) continue;
                cachedCalc.checkTTL();
            }
        }
        if (this.statistics) {
            this.stats.crawls.incrementAndGet();
        }
    }

    @Override
    public V get(K key) {
        SimpleBucket<MapEntry<K, ConcurrentCacheAtom<K, V>>> bucket;
        MapEntry<K, Object> entry;
        int hash = key.hashCode();
        L1CacheSegment<K, V> l1 = this.l1Segment(hash);
        ConcurrentCacheAtom<K, V> l1atom = l1.find(key);
        if (l1atom != null) {
            if (this.statistics) {
                this.stats.l1Hits.incrementAndGet();
            }
            return l1atom.get();
        }
        if (this.statistics) {
            this.stats.l1Misses.incrementAndGet();
        }
        if ((entry = this.findEntry(key, bucket = this.l2segment(hash))) != null) {
            l1.add(hash, (ConcurrentCacheAtom)entry.value);
            ConcurrentCacheAtom atom = (ConcurrentCacheAtom)entry.value;
            return atom.get();
        }
        ConcurrentCacheAtom<K, V> atom = this.createAtom(key);
        entry = this.putAtom(key, bucket, atom);
        l1.add(hash, (ConcurrentCacheAtom)entry.value);
        return atom.get();
    }

    @Override
    public V getIfExists(K key) {
        MapEntry entry;
        int hash = key.hashCode();
        L1CacheSegment<K, V> l1 = this.l1Segment(hash);
        ConcurrentCacheAtom<K, V> l1atom = l1.find(key);
        if (l1atom != null) {
            if (this.statistics) {
                this.stats.l1Hits.incrementAndGet();
            }
            return l1atom.getIfExists();
        }
        if (this.statistics) {
            this.stats.l1Misses.incrementAndGet();
        }
        if ((entry = this.findEntry(key)) != null) {
            l1.add(hash, (ConcurrentCacheAtom)entry.value);
            return ((ConcurrentCacheAtom)entry.value).getIfExists();
        }
        return null;
    }

    private ConcurrentCacheAtom<K, V> createAtom(K key) {
        return this.statistics ? new ConcurrentCacheAtomWithStats<K, V>(key, this.loader, this.ttlInMs, this.stats) : new ConcurrentCacheAtom<K, V>(key, this.loader, this.ttlInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapEntry<K, ConcurrentCacheAtom<K, V>> putAtom(K key, SimpleBucket<MapEntry<K, ConcurrentCacheAtom<K, V>>> bucket, ConcurrentCacheAtom<K, V> atom) {
        SimpleBucket simpleBucket = bucket;
        synchronized (simpleBucket) {
            MapEntry<K, Object> entry = this.findEntry(key, bucket);
            if (entry == null) {
                entry = new MapEntry<K, ConcurrentCacheAtom<K, V>>(key, atom);
                bucket.add(entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(K key) {
        SimpleBucket bucket;
        int hash = key.hashCode();
        this.l1Segment(hash).invalidate(key);
        SimpleBucket simpleBucket = bucket = this.l2segment(hash);
        synchronized (simpleBucket) {
            MapEntry entry = this.findEntry(key, bucket);
            if (entry != null) {
                ((ConcurrentCacheAtom)entry.value).invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(K key, V value) {
        SimpleBucket<MapEntry<K, ConcurrentCacheAtom<K, V>>> bucket;
        int hash = key.hashCode();
        this.l1Segment(hash).set(key, value);
        SimpleBucket<MapEntry<K, ConcurrentCacheAtom<K, V>>> simpleBucket = bucket = this.l2segment(hash);
        synchronized (simpleBucket) {
            MapEntry entry = this.findEntry(key, bucket);
            if (entry != null) {
                ((ConcurrentCacheAtom)entry.value).set(value);
            } else {
                ConcurrentCacheAtom<K, V> atom = this.createAtom(key);
                atom.set(value);
                this.putAtom(key, bucket, atom);
            }
        }
    }

    public long ttlInMs() {
        return this.ttlInMs;
    }

    @Override
    public CacheStats stats() {
        return this.stats;
    }

    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = 0;
        for (int index = 0; index < this.entries.bucketCount(); ++index) {
            SimpleBucket bucket;
            SimpleBucket simpleBucket = bucket = this.entries.getBucketAt(index);
            synchronized (simpleBucket) {
                size += bucket.size();
                continue;
            }
        }
        return size;
    }

    private L1CacheSegment<K, V> l1Segment(int hash) {
        return this.l1Cache[(hash ^ this.l1Xor) & this.l1BitMask];
    }

    private SimpleBucket<MapEntry<K, ConcurrentCacheAtom<K, V>>> l2segment(int hash) {
        return this.entries.bucket(hash);
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void bypass() {
        this.stats.bypassed.incrementAndGet();
    }

    @Override
    public synchronized void clear() {
        super.clear();
        for (L1CacheSegment<K, V> l1 : this.l1Cache) {
            l1.clear();
        }
    }
}

