/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cache.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cache.CacheAtom;
import org.rapidoid.cache.impl.CachedValue;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;
import org.rapidoid.util.Resetable;

public class ConcurrentCacheAtom<K, V>
extends RapidoidThing
implements CacheAtom<V>,
Callable<V> {
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final K key;
    protected final Mapper<K, V> loader;
    protected final long ttlInMs;
    protected volatile CachedValue<V> cachedValue;
    long approxAccessCounter;

    public ConcurrentCacheAtom(K key, Mapper<K, V> loader, long ttlInMs) {
        this.key = key;
        this.loader = loader;
        this.ttlInMs = ttlInMs;
    }

    @Override
    public V get() {
        return this.retrieveCachedValue(true, true);
    }

    @Override
    public V getIfExists() {
        return this.retrieveCachedValue(false, true);
    }

    private V retrieveCachedValue(boolean loadIfExpired, boolean updateStats) {
        long now;
        V oldValue = null;
        Throwable error = null;
        boolean missed = false;
        ++this.approxAccessCounter;
        CachedValue<V> cached = this.cachedValue;
        if (cached != null) {
            long expiresAt = cached.expiresAt;
            if (expiresAt == Long.MAX_VALUE) {
                this.updateStats(false, false);
                return cached.value;
            }
            now = U.time();
            if (now <= expiresAt) {
                this.updateStats(false, false);
                return cached.value;
            }
        } else {
            now = U.time();
        }
        this.readLock();
        cached = this.cachedValue;
        if (cached == null || now > cached.expiresAt) {
            this.readUnlock();
            this.writeLock();
            if (cached == null || now > cached.expiresAt) {
                Object newValue;
                if (loadIfExpired) {
                    try {
                        newValue = this.loader != null ? this.loader.map(this.key) : null;
                    }
                    catch (Throwable e) {
                        error = e;
                        newValue = null;
                    }
                } else {
                    newValue = null;
                }
                oldValue = this.setValueInsideWriteLock(newValue);
                missed = true;
            }
            this.readLock();
            this.writeUnlock();
        }
        V result = (cached = this.cachedValue) != null ? (V)cached.value : null;
        this.readUnlock();
        this.releaseOldValue(oldValue);
        if (updateStats) {
            this.updateStats(missed, error != null);
        }
        if (error != null) {
            throw U.rte((String)"Couldn't recalculate the cache value!", (Throwable)error);
        }
        return result;
    }

    private void readLock() {
        try {
            if (!this.lock.readLock().tryLock(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Couldn't acquire READ lock!");
            }
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        try {
            if (!this.lock.writeLock().tryLock(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Couldn't acquire WRITE lock!");
            }
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    protected void updateStats(boolean missed, boolean hasError) {
    }

    @Override
    public void set(V value) {
        this.writeLock();
        V oldValue = this.setValueInsideWriteLock(value);
        this.writeUnlock();
        this.releaseOldValue(oldValue);
    }

    private V setValueInsideWriteLock(V newValue) {
        V oldValue;
        CachedValue<V> cached = this.cachedValue;
        V v = oldValue = cached != null ? (V)cached.value : null;
        if (newValue != null) {
            long expiresAt = this.ttlInMs > 0L ? U.time() + this.ttlInMs : Long.MAX_VALUE;
            this.cachedValue = new CachedValue<V>(newValue, expiresAt);
        } else {
            this.cachedValue = null;
        }
        return oldValue;
    }

    @Override
    public void invalidate() {
        this.writeLock();
        V oldValue = this.setValueInsideWriteLock(null);
        this.writeUnlock();
        this.releaseOldValue(oldValue);
    }

    private void releaseOldValue(V oldValue) {
        if (oldValue instanceof Resetable) {
            ((Resetable)oldValue).reset();
        }
    }

    void checkTTL() {
        this.retrieveCachedValue(false, false);
    }

    @Override
    public V call() throws Exception {
        return this.get();
    }

    public String toString() {
        return "ConcurrentCacheAtom{lock=" + this.lock + ", loader=" + this.loader + ", ttlInMs=" + this.ttlInMs + ", cachedValue=" + this.cachedValue + '}';
    }
}

