/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cache.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.cache.impl.CacheStats;
import org.rapidoid.cache.impl.ConcurrentCacheAtom;
import org.rapidoid.lambda.Mapper;

public class ConcurrentCacheAtomWithStats<K, V>
extends ConcurrentCacheAtom<K, V> {
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private final AtomicLong errors = new AtomicLong();
    private final CacheStats stats;

    public ConcurrentCacheAtomWithStats(K key, Mapper<K, V> loader, long ttlInMs, CacheStats stats) {
        super(key, loader, ttlInMs);
        this.stats = stats;
    }

    @Override
    protected void updateStats(boolean missed, boolean hasError) {
        if (hasError) {
            this.errors.incrementAndGet();
            this.stats.errors.incrementAndGet();
        } else if (missed) {
            this.misses.incrementAndGet();
            this.stats.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
            this.stats.hits.incrementAndGet();
        }
    }

    public AtomicLong getHits() {
        return this.hits;
    }

    public AtomicLong getMisses() {
        return this.misses;
    }

    public AtomicLong getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        return "ConcurrentCacheAtomWithStats{hits=" + this.hits + ", misses=" + this.misses + ", errors=" + this.errors + ", stats=" + (Object)((Object)this.stats) + '}';
    }
}

