/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.rapidoid.RapidoidThing;
import org.rapidoid.u.U;

public class Dates
extends RapidoidThing {
    protected static final Calendar CALENDAR = Calendar.getInstance();
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static volatile long updateCurrDateAfter = 0L;
    private static volatile byte[] CURR_DATE_BYTES;

    public static byte[] getDateTimeBytes() {
        long time = System.currentTimeMillis();
        if (time > updateCurrDateAfter) {
            SimpleDateFormat dateFormat = Dates.frmt("EEE, dd MMM yyyy HH:mm:ss z");
            dateFormat.setTimeZone(GMT);
            Date date = new Date();
            date.setTime(time);
            CURR_DATE_BYTES = dateFormat.format(date).getBytes();
            updateCurrDateAfter = time + 1000L;
        }
        return CURR_DATE_BYTES;
    }

    public static Date date(String value) {
        if (U.isEmpty((String)value)) {
            return null;
        }
        String[] parts = value.split("(\\.|-|/)");
        int a = parts.length > 0 ? U.num((String)parts[0]) : -1;
        int b = parts.length > 1 ? U.num((String)parts[1]) : -1;
        int c = parts.length > 2 ? U.num((String)parts[2]) : -1;
        switch (parts.length) {
            case 3: {
                if (Dates.isDay(a) && Dates.isMonth(b) && Dates.isYear(c)) {
                    return Dates.date(a, b, c);
                }
                if (!Dates.isYear(a) || !Dates.isMonth(b) || !Dates.isDay(c)) break;
                return Dates.date(c, b, a);
            }
            case 2: {
                if (!Dates.isDay(a) || !Dates.isMonth(b)) break;
                return Dates.date(a, b, Dates.thisYear());
            }
        }
        throw U.rte((String)("Invalid date: " + value));
    }

    private static boolean isDay(int day) {
        return day >= 1 && day <= 31;
    }

    private static boolean isMonth(int month) {
        return month >= 1 && month <= 12;
    }

    private static boolean isYear(int year) {
        return year >= 1000;
    }

    public static synchronized Date date(int day, int month, int year) {
        CALENDAR.set(year, month - 1, day, 0, 0, 0);
        return CALENDAR.getTime();
    }

    public static synchronized int thisYear() {
        CALENDAR.setTime(new Date());
        return CALENDAR.get(1);
    }

    public static String str(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        df.setTimeZone(UTC);
        return df.format(date);
    }

    public static String iso(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(UTC);
        return df.format(date);
    }

    public static String day() {
        return Dates.frmt("yyyy-MM-dd").format(U.time());
    }

    public static String hour() {
        return Dates.frmt("yyyy-MM-dd-HH").format(U.time());
    }

    public static String minute() {
        return Dates.frmt("yyyy-MM-dd-HH-mm").format(U.time());
    }

    public static String second() {
        return Dates.frmt("yyyy-MM-dd-HH-mm-ss").format(U.time());
    }

    public static SimpleDateFormat frmt(String frmt) {
        return new SimpleDateFormat(frmt);
    }

    public static String frmt(String frmt, Date date) {
        return Dates.frmt(frmt).format(date);
    }

    public static Calendar calendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String readable(Date date) {
        Calendar cal = Dates.calendar(date);
        if (cal.get(1) == Dates.thisYear()) {
            return Dates.frmt("dd MMM, HH:mm", date);
        }
        return Dates.frmt("dd MMM yyyy, HH:mm", date);
    }

    public static String details(Date date) {
        return Dates.frmt("EEE, dd MMM yyyy HH:mm:ss z", date);
    }
}

