/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.rapidoid.RapidoidThing;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;

public class Str
extends RapidoidThing {
    public static final String CAMEL_REGEX = "(?<=[A-Z])(?=[A-Z][a-z])|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Za-z])(?=[^A-Za-z])";
    private static final Pattern CAMEL_SPLITTER_PATTERN = Pattern.compile("(?<=[A-Z])(?=[A-Z][a-z])|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Za-z])(?=[^A-Za-z])");
    private static final String[][] XML_ESCAPE = new String[][]{{"&", "&amp;"}, {"\"", "&quot;"}, {"<", "&lt;"}, {">", "&gt;"}};
    private static final String[][] JAVA_ESCAPE = new String[][]{{"\n", "\\\\n"}, {"\r", "\\\\r"}, {"\t", "\\\\t"}, {"\"", "\\\\\""}};
    private static final Mapper<String[], String> MASK_REPLACER = new Mapper<String[], String>(){

        @Override
        public String map(String[] src) throws Exception {
            return Str.mul("\u0000", src[0].length());
        }
    };

    private Str() {
    }

    public static String[] camelSplit(String s) {
        return CAMEL_SPLITTER_PATTERN.split(s);
    }

    public static String phrase(String s) {
        Object[] parts = s.contains("_") ? s.split("_") : Str.camelSplit(s);
        return Str.capitalized(U.join((String)" ", (Object[])parts).toLowerCase());
    }

    public static String replace(String s, String[][] repls) {
        for (String[] repl : repls) {
            U.must((repl.length == 2 ? 1 : 0) != 0, (String)"Expected pairs of [search, replacement] strings!");
            s = s.replaceAll(Pattern.quote(repl[0]), repl[1]);
        }
        return s;
    }

    public static String mask(String target, Pattern regex) {
        return Str.replace(target, regex, MASK_REPLACER);
    }

    public static String replace(String target, String regex, Mapper<String[], String> replacer) {
        return Str.replace(target, Pattern.compile(regex), replacer);
    }

    public static String replace(String target, Pattern regex, Mapper<String[], String> replacer) {
        return Str.replace(target, target, regex, replacer);
    }

    public static String replace(String target, String mask, Pattern regex, Mapper<String[], String> replacer) {
        U.must((target.length() == mask.length() ? 1 : 0) != 0);
        StringBuffer output = new StringBuffer();
        Matcher m = regex.matcher(mask);
        int pos = 0;
        while (m.find()) {
            int len = m.groupCount() + 1;
            String[] groups = new String[len];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = m.group(i);
            }
            String replacement = Lmbd.eval(replacer, groups);
            output.append(target.substring(pos, m.start()));
            output.append(replacement);
            pos = m.end();
        }
        output.append(target.substring(pos));
        return output.toString();
    }

    public static String render(Object[] items, String itemFormat, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(U.frmt((String)itemFormat, (Object[])new Object[]{items[i]}));
        }
        return sb.toString();
    }

    public static String render(Iterable<?> items, String itemFormat, String sep) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object item : items) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(U.frmt((String)itemFormat, (Object[])new Object[]{item}));
            ++i;
        }
        return sb.toString();
    }

    public static String render(Map<?, ?> items, String itemFormat, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int index = 0;
        for (Map.Entry<?, ?> e : items.entrySet()) {
            if (!first) {
                sb.append(sep);
            }
            String s = itemFormat.replaceAll(Pattern.quote("${key}"), String.valueOf(e.getKey())).replaceAll(Pattern.quote("${value}"), String.valueOf(e.getValue())).replaceAll(Pattern.quote("${index}"), String.valueOf(index));
            sb.append(s);
            first = false;
            ++index;
        }
        return sb.toString();
    }

    public static String capitalized(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String uncapitalized(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String mul(String s, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String sub(String s, int beginIndex, int endIndex) {
        if (endIndex < 0) {
            endIndex = s.length() + endIndex;
        }
        return s.substring(beginIndex, endIndex);
    }

    public static String trimr(String s, char suffix) {
        return !s.isEmpty() && s.charAt(s.length() - 1) == suffix ? Str.sub(s, 0, -1) : s;
    }

    public static String trimr(String s, String suffix) {
        return s.endsWith(suffix) ? Str.sub(s, 0, -suffix.length()) : s;
    }

    public static String triml(String s, char prefix) {
        return !s.isEmpty() && s.charAt(0) == prefix ? s.substring(1) : s;
    }

    public static String triml(String s, String prefix) {
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    public static String insert(String target, int atIndex, String insertion) {
        return target.substring(0, atIndex) + insertion + target.substring(atIndex);
    }

    public static String cutToFirst(String s, String delimiter) {
        int pos = s.indexOf(delimiter);
        return pos >= 0 ? s.substring(0, pos) : null;
    }

    public static String cutToLast(String s, String delimiter) {
        int pos = s.lastIndexOf(delimiter);
        return pos >= 0 ? s.substring(0, pos) : null;
    }

    public static String cutFromFirst(String s, String delimiter) {
        int pos = s.indexOf(delimiter);
        return pos >= 0 ? s.substring(pos + delimiter.length()) : null;
    }

    public static String cutFromLast(String s, String delimiter) {
        int pos = s.lastIndexOf(delimiter);
        return pos >= 0 ? s.substring(pos + delimiter.length()) : null;
    }

    public static String xmlEscape(String s) {
        return Str.replace(s, XML_ESCAPE);
    }

    public static String javaEscape(String s) {
        return Str.replace(s, JAVA_ESCAPE);
    }

    public static String camelToSnake(String s) {
        return U.join((String)"_", (Object[])Str.camelSplit(s)).toLowerCase();
    }

    public static String toHex(byte[] data) {
        return DatatypeConverter.printHexBinary((byte[])data);
    }

    public static byte[] fromHex(String hex) {
        return DatatypeConverter.parseHexBinary((String)hex);
    }

    public static String toBase64(byte[] data) {
        return DatatypeConverter.printBase64Binary((byte[])data);
    }

    public static String toBase64(byte[] data, char plusReplacement, char slashReplacement) {
        return Str.toBase64(data).replace('+', plusReplacement).replace('/', slashReplacement);
    }

    public static String toWebSafeBase64(byte[] data) {
        return Str.toBase64(data, '-', '_');
    }

    public static String toWebSafeBinary(byte[] data) {
        String s = Str.toWebSafeBase64(data);
        StringBuilder sb = new StringBuilder();
        int k = 7;
        for (int i = 0; i < s.length(); i += k) {
            if (i > 0) {
                sb.append(":");
            }
            sb.append(s.substring(i, Math.min(i + k, s.length())));
        }
        return sb.toString();
    }

    public static boolean isWebSafeBinary(String s) {
        int k;
        boolean foundMarks = false;
        for (int i = k = 7; i < s.length(); i += k + 1) {
            if (s.charAt(i) != ':') {
                return false;
            }
            foundMarks = true;
        }
        return foundMarks;
    }

    public static byte[] fromWebSafeBinary(String binary) {
        return Str.fromWebSafeBase64(binary.replaceAll(":", ""));
    }

    public static byte[] fromBase64(String base64) {
        return DatatypeConverter.parseBase64Binary((String)base64);
    }

    public static byte[] fromBase64(String base64, char plusReplacement, char slashReplacement) {
        return Str.fromBase64(base64.replace(plusReplacement, '+').replace(slashReplacement, '/'));
    }

    public static byte[] fromWebSafeBase64(String base64) {
        return Str.fromBase64(base64, '-', '_');
    }

    public static String wildcardToRegex(String pattern) {
        if (pattern.isEmpty()) {
            return "";
        }
        if (pattern.equals("*")) {
            return "(.*)";
        }
        String[] nameParts = pattern.split("\\*", Integer.MAX_VALUE);
        StringBuilder sb = new StringBuilder();
        for (String part : nameParts) {
            String s = part.isEmpty() ? "(.*)" : Pattern.quote(part);
            sb.append(s);
        }
        return sb.toString();
    }

    public static String wildcardsToRegex(String ... patterns) {
        if (U.isEmpty((Object[])patterns)) {
            return "";
        }
        if (patterns.length == 1) {
            return Str.wildcardToRegex(patterns[0]);
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = U.iterator((Object[])patterns);
        while (it.hasNext()) {
            String pattern = (String)it.next();
            sb.append(Str.wildcardToRegex(pattern));
            if (!it.hasNext()) continue;
            sb.append("|");
        }
        return "(?:" + sb + ")";
    }

    public static List<String> linesOf(String s) {
        return U.list((Object[])s.split("\\n"));
    }

    public static List<String> grep(String regex, Iterable<String> lines) {
        List matching = U.list();
        Pattern p = Pattern.compile(regex);
        for (String line : lines) {
            if (!p.matcher(line).find()) continue;
            matching.add(line);
        }
        return matching;
    }
}

