/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.Beany;
import org.rapidoid.cls.Cls;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Arr;
import org.rapidoid.config.BasicConfig;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigAlternatives;
import org.rapidoid.config.ConfigBase;
import org.rapidoid.config.ConfigChangeListener;
import org.rapidoid.config.ConfigChanges;
import org.rapidoid.config.ConfigLoaderUtil;
import org.rapidoid.config.ConfigValueStore;
import org.rapidoid.env.Env;
import org.rapidoid.env.RapidoidEnv;
import org.rapidoid.lambda.Operation;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.value.Value;
import org.rapidoid.value.Values;

public class ConfigImpl
extends RapidoidThing
implements Config {
    private final List<String> baseKeys;
    private final ConfigImpl root;
    private final ConfigBase base;
    private final boolean isRoot;

    public ConfigImpl() {
        this(null, false);
    }

    public ConfigImpl(Map<String, Object> entries) {
        this();
        this.update(entries);
    }

    public ConfigImpl(String defaultFilenameBase) {
        this(defaultFilenameBase, false);
    }

    public ConfigImpl(String defaultFilenameBase, boolean useBuiltInDefaults) {
        this.base = new ConfigBase(defaultFilenameBase, useBuiltInDefaults);
        this.root = this;
        this.baseKeys = U.list();
        this.isRoot = true;
    }

    private ConfigImpl(ConfigBase base, List<String> baseKeys, ConfigImpl root) {
        this.base = base;
        this.root = root;
        this.baseKeys = Collections.unmodifiableList(U.list(baseKeys));
        this.isRoot = false;
    }

    @Override
    public synchronized void reset() {
        this.clear();
        this.base.reset();
    }

    @Override
    public void invalidate() {
        this.clear();
        this.base.invalidate();
    }

    @Override
    public Value<Object> entry(String key) {
        return Values.wrap(new ConfigValueStore(this, key));
    }

    private List<String> keyChain(Iterator<String> keys) {
        List keyChain = U.list(this.baseKeys);
        while (keys.hasNext()) {
            String key = keys.next();
            U.notNull((Object)key, (String)"config key", (Object[])new Object[0]);
            Collections.addAll(keyChain, key.split("\\."));
        }
        return keyChain;
    }

    @Override
    public Config sub(String ... keys) {
        U.must((boolean)U.notEmpty((Object[])keys), (String)"Keys must be specified!");
        return new ConfigImpl(this.base, this.keyChain(U.iterator((Object[])keys)), this.root());
    }

    @Override
    public Config sub(List<String> keys) {
        U.must((boolean)U.notEmpty(keys), (String)"Keys must be specified!");
        return new ConfigImpl(this.base, this.keyChain(keys.iterator()), this.root());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        Object value;
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            value = this.asMap().get(key);
        }
        if (value == null) {
            value = this.globalOrArgConfigByRelativeKey(key);
        }
        return value;
    }

    private Object globalOrArgConfigByRelativeKey(String relKey) {
        String key = this.fullKey(relKey, ".");
        return this.globalOrArgConfig(key);
    }

    private String fullKey(String key, String separator) {
        return U.join((String)separator, (Object[])Arr.concat(U.array(this.baseKeys), key));
    }

    @Override
    public boolean has(String key) {
        this.makeSureIsInitialized();
        return this.get(key) != null;
    }

    @Override
    public boolean is(String key) {
        this.makeSureIsInitialized();
        Object value = this.get(key);
        try {
            return Boolean.TRUE.equals(Cls.convert(value, Boolean.class));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, Object> toMap() {
        this.makeSureIsInitialized();
        return Collections.unmodifiableMap(this.asMap());
    }

    @Override
    public <T> Map<String, T> toMap(Class<T> type) {
        return Coll.toBeanMap(this.toMap(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> asMap() {
        this.makeSureIsInitialized();
        if (this.isRoot) {
            return this.base.properties;
        }
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            Map<String, Object> props = this.base.properties;
            for (String key : this.baseKeys) {
                Map value = props.get(key);
                if (value == null) {
                    value = Coll.synchronizedMap();
                    props.put(key, value);
                }
                if (value instanceof Map) {
                    props = value;
                    continue;
                }
                throw U.rte((String)"Expected a Map for configuration section '%s', but found value of type: %s", (Object[])new Object[]{this.sectionTo(key), value.getClass().getSimpleName()});
            }
            return props;
        }
    }

    private String sectionTo(String toKey) {
        String section = "";
        for (String key : this.baseKeys) {
            if (!section.isEmpty()) {
                section = section + ".";
            }
            section = section + key;
            if (!key.equals(toKey)) continue;
            break;
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.isRoot) {
            this.base.properties.clear();
        } else {
            Map<String, Object> map = this.base.properties;
            synchronized (map) {
                this.parent().remove(this.lastBaseKey());
            }
        }
    }

    private String lastBaseKey() {
        return this.baseKeys.get(this.baseKeys.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            this.asMap().remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Map<String, Object> entries) {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            this.clear();
            this.update(entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            return this.asMap().isEmpty() && !Env.properties().hasPrefix(U.join((String)"_", this.baseKeys) + "_");
        }
    }

    @Override
    public void update(Map<String, ?> entries) {
        this.makeSureIsInitialized();
        this.update(entries, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Map<String, ?> entries, boolean overridenByEnv) {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            for (Map.Entry<String, ?> e : entries.entrySet()) {
                String name = e.getKey();
                Object value = e.getValue();
                if (value instanceof Map) {
                    this.sub(name).update((Map)value, overridenByEnv);
                    continue;
                }
                this.set(name, value, overridenByEnv);
            }
        }
    }

    @Override
    public void set(String key, Object value) {
        this.set(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, Object value, boolean overridenByEnv) {
        this.makeSureIsInitialized();
        Object[] keys = key.split("\\.");
        if (keys.length > 1) {
            Config cfg = this.sub(Arr.sub(keys, 0, -1));
            cfg.set((String)U.last((Object[])keys), value, overridenByEnv);
            return;
        }
        if (overridenByEnv) {
            value = U.or((Object)this.globalOrArgConfigByRelativeKey(key), (Object)value);
        }
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            this.asMap().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            return this.asMap().toString();
        }
    }

    @Override
    @Deprecated
    public void args(List<String> args) {
        this.mustBeRoot();
        this.base.initial.putAll(Msc.parseArgs(args));
    }

    private Object globalOrArgConfig(String key) {
        return U.or((Object)this.base.initial.get(key), (Object)Env.properties().get(key));
    }

    private void mustBeRoot() {
        RapidoidEnv.touch();
        U.must((boolean)this.isRoot, (String)"Must be Config's root!");
    }

    @Override
    public ConfigImpl root() {
        return this.root;
    }

    @Override
    public Config parent() {
        if (this.isRoot) {
            return null;
        }
        List<String> parentsKeys = this.baseKeys.subList(0, this.baseKeys.size() - 1);
        return parentsKeys.isEmpty() ? this.root : this.root.sub(parentsKeys);
    }

    @Override
    public List<String> keys() {
        return this.baseKeys;
    }

    @Override
    public Map<String, String> toFlatMap() {
        this.makeSureIsInitialized();
        Map flatMap = U.map();
        Map<String, Object> map = this.toMap();
        ConfigImpl.traverseToFlat(map, U.list(this.keys()), flatMap);
        return flatMap;
    }

    private static void traverseToFlat(Map<String, Object> map, List<String> keys, Map<String, String> flatMap) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            if (val instanceof Map) {
                Map mapVal = (Map)val;
                List keys2 = U.list(keys);
                keys2.add(key);
                ConfigImpl.traverseToFlat(mapVal, keys2, flatMap);
                continue;
            }
            flatMap.put(U.join((String)".", keys) + "." + key, String.valueOf(val));
        }
    }

    @Override
    public Properties toProperties() {
        this.makeSureIsInitialized();
        Properties props = new Properties();
        props.putAll(this.toFlatMap());
        return props;
    }

    @Override
    public ConfigAlternatives or(BasicConfig alternative) {
        return new ConfigAlternatives(this, alternative);
    }

    @Override
    public String getFilenameBase() {
        return this.base.getFilenameBase();
    }

    @Override
    public Config setFilenameBase(String filenameBase) {
        this.mustBeRoot();
        if (this.base.setFilenameBase(filenameBase)) {
            this.invalidate();
        }
        return this;
    }

    @Override
    public String getPath() {
        return this.base.getPath();
    }

    @Override
    public Config setPath(String path) {
        this.mustBeRoot();
        if (this.base.setPath(path)) {
            this.invalidate();
        }
        if (new File(path).isAbsolute()) {
            Msc.watchForChanges(path, new Operation<String>(){

                @Override
                public void execute(String filename) throws Exception {
                    ConfigImpl.this.onFileSystemChange(filename);
                }
            });
        }
        return this;
    }

    @Override
    public void applyTo(Object target) {
        this.makeSureIsInitialized();
        Beany.update(target, this.toMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSureIsInitialized() {
        if (this.base.initializing) {
            return;
        }
        if (!this.base.initialized) {
            ConfigImpl configImpl = this;
            synchronized (configImpl) {
                if (!this.base.initialized) {
                    this.base.initializing = true;
                    this.root.initialize();
                    this.base.initialized = true;
                }
            }
        }
    }

    protected synchronized void initialize() {
        boolean useConfigFiles;
        this.mustBeRoot();
        List loaded = U.list();
        this.base.initial.putAll(Env.argsAsMap());
        this.overrideByEnv();
        if (this.useBuiltInDefaults()) {
            ConfigLoaderUtil.loadBuiltInConfig(this, loaded);
        }
        if (useConfigFiles = U.notEmpty((String)this.getFilenameBase())) {
            ConfigLoaderUtil.loadConfig(this, loaded);
        }
        this.overrideByEnv();
        Conf.applyConfig(this);
        if (!loaded.isEmpty()) {
            Log.info((String)"Loaded configuration", (String)"namespace", (Object)this.getFilenameBase(), (String)"!files", (Object)loaded);
        } else if (useConfigFiles) {
            Log.warn((String)"Didn't find any configuration files", (String)"path", (Object)this.getPath());
        }
    }

    private void overrideByEnv() {
        this.base.applyInitialConfig(this);
    }

    @Override
    public boolean useBuiltInDefaults() {
        return this.base.useBuiltInDefaults();
    }

    @Override
    public boolean isInitialized() {
        RapidoidEnv.touch();
        return this.base.initialized;
    }

    @Override
    public ConfigChanges getChangesSince(Config previousConfig) {
        boolean initial;
        boolean bl = initial = previousConfig == null;
        Map<String, Object> prevMap = !initial ? (this.isRoot ? previousConfig.toMap() : previousConfig.sub(this.keys()).toMap()) : U.map();
        return ConfigChanges.from(this.keys(), prevMap, this.toMap(), initial);
    }

    @Override
    public synchronized void addChangeListener(Operation<ConfigChanges> configChangeListener) {
        ConfigChangeListener listener = new ConfigChangeListener(this.keys(), configChangeListener);
        this.base.configChangesListeners.add(listener);
        this.root().notifyChangeListener(listener, null);
    }

    @Override
    public synchronized void removeChangeListener(Operation<ConfigChanges> configChangeListener) {
        this.base.configChangesListeners.remove((Object)new ConfigChangeListener(this.keys(), configChangeListener));
    }

    private synchronized void onFileSystemChange(String filename) {
        this.mustBeRoot();
        if (filename.endsWith(".yaml") || filename.endsWith(".yml") || filename.endsWith(".json")) {
            Log.info((String)"Detected configuration file changes", (String)"file", (Object)filename);
            this.reloadAndProcessChanges();
        }
    }

    private void reloadAndProcessChanges() {
        this.mustBeRoot();
        Set listeners = U.set(this.base.configChangesListeners);
        if (listeners.isEmpty()) {
            return;
        }
        ConfigImpl previousConfig = new ConfigImpl(Coll.deepCopyOf(this.toMap()));
        this.invalidate();
        this.makeSureIsInitialized();
        for (ConfigChangeListener listener : listeners) {
            this.notifyChangeListener(listener, previousConfig);
        }
    }

    private void notifyChangeListener(ConfigChangeListener listener, Config previousConfig) {
        this.mustBeRoot();
        ConfigImpl cfg = U.notEmpty(listener.keys) ? this.sub(listener.keys) : this;
        ConfigChanges changes = cfg.getChangesSince(previousConfig);
        if (changes.count() > 0) {
            try {
                listener.operation.execute(changes);
            }
            catch (Exception e) {
                Log.error((String)"Error occurred in a configuration changes listener!", (Throwable)e);
            }
        }
    }

    @Override
    public Config defaultOrCustom(String name) {
        U.must((boolean)U.notEmpty((String)name), (String)"The configuration name cannot be empty! Use name 'default' for the default configuration.");
        if (name.equalsIgnoreCase("default")) {
            return this;
        }
        String configKey = (String)U.last(this.keys()) + "-" + name;
        return this.parent().sub(configKey);
    }
}

