/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.crypto;

import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Arr;
import org.rapidoid.crypto.AESCypherTool;
import org.rapidoid.crypto.Crypto;

public class CryptoKey
extends RapidoidThing {
    final byte[] encryptionKey;
    final byte[] hmacKey;

    public CryptoKey(byte[] encryptionKey, byte[] hmacKey) {
        this.encryptionKey = encryptionKey;
        this.hmacKey = hmacKey;
    }

    public static CryptoKey from(char[] password) {
        int totalSize = AESCypherTool.AES_KEY_LENGTH + 256;
        byte[] keys = Crypto.pbkdf2(password, Crypto.DEFAULT_PBKDF2_SALT, 100000, totalSize);
        byte[] encryptionKey = new byte[AESCypherTool.AES_KEY_LENGTH / 8];
        byte[] hmacKey = new byte[32];
        Arr.split(keys, encryptionKey, hmacKey);
        return new CryptoKey(encryptionKey, hmacKey);
    }
}

