/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.datamodel.impl;

import java.util.Iterator;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.datamodel.PageableData;
import org.rapidoid.datamodel.Results;
import org.rapidoid.datamodel.impl.PagingIterator;
import org.rapidoid.u.U;

public class ResultsImpl<T>
extends RapidoidThing
implements Results<T> {
    private final PageableData<T> data;

    public ResultsImpl(PageableData<T> data) {
        this.data = data;
    }

    protected PageableData<T> data() {
        return this.data;
    }

    @Override
    public final Iterator<T> iterator() {
        return new PagingIterator<T>(this.data);
    }

    @Override
    public final List<T> all() {
        return this.retrievePage(0L, Long.MAX_VALUE);
    }

    @Override
    public final List<T> page(long start, long length) {
        return this.retrievePage(start, length);
    }

    @Override
    public T single() {
        return (T)U.single(this.retrievePage(0L, 2L));
    }

    @Override
    public final T first() {
        return (T)U.single(this.retrievePage(0L, 1L));
    }

    @Override
    public final T last() {
        return (T)U.single(this.retrievePage(this.count() - 1L, 1L));
    }

    private List<T> retrievePage(long start, long length) {
        return this.data().getPage(start, length);
    }

    @Override
    public long count() {
        long count = this.data().getCount();
        if (count < 0L) {
            count = 0L;
            Iterator<T> it = this.iterator();
            while (it.hasNext()) {
                it.next();
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean isSingle() {
        long count = this.data().getCount();
        if (count >= 0L) {
            return count == 1L;
        }
        return this.retrievePage(0L, 2L).size() == 1;
    }
}

