/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.expire;

import java.util.List;
import org.rapidoid.activity.RapidoidThread;
import org.rapidoid.collection.Coll;
import org.rapidoid.expire.Expiring;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class ExpirationCrawlerThread
extends RapidoidThread {
    private final int resolution;
    private final List<Iterable<? extends Expiring>> collections = Coll.synchronizedList(new Iterable[0]);

    public ExpirationCrawlerThread(String name, int resolution) {
        super(name);
        this.resolution = resolution;
        this.setPriority(1);
        this.setDaemon(true);
    }

    public void register(Iterable<? extends Expiring> collection) {
        this.collections.add(collection);
    }

    public void deregister(Iterable<? extends Expiring> collection) {
        this.collections.remove(collection);
    }

    @Override
    public void run() {
        long startedAt = U.time();
        while (!Thread.interrupted()) {
            long timeSpent = U.time() - startedAt;
            U.sleep((long)Math.max((long)this.resolution - timeSpent, 0L));
            startedAt = U.time();
            this.crawl();
        }
    }

    private void crawl() {
        for (Iterable<? extends Expiring> coll : Coll.copyOf(this.collections)) {
            long now = U.time();
            for (Expiring expiring : coll) {
                try {
                    long expiresAt = expiring.getExpiresAt();
                    if (expiresAt <= 0L || expiresAt >= now) continue;
                    expiring.expire();
                    expiring.setExpiresAt(0L);
                }
                catch (Exception e) {
                    Log.error((String)"Error on expiration!", (Throwable)e);
                }
            }
        }
    }
}

