/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.group;

import java.util.Collections;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.group.GroupStats;
import org.rapidoid.group.Groups;
import org.rapidoid.group.Manageable;
import org.rapidoid.group.ManageableBean;
import org.rapidoid.u.U;

public class GroupOf<E extends Manageable>
extends RapidoidThing {
    private final String kind;
    private final Class<E> itemType;
    private final String name;
    private final List<E> items = Coll.synchronizedList(new Manageable[0]);
    private final GroupStats stats = new GroupStats();

    private static String kindOf(Class<? extends Manageable> cls) {
        ManageableBean mb = cls.getAnnotation(ManageableBean.class);
        U.must((mb != null ? 1 : 0) != 0, (String)"The type '%s' must be annotated with @%s", (Object)ManageableBean.class.getSimpleName());
        return mb.kind();
    }

    public GroupOf(Class<E> itemType, String name) {
        this.kind = GroupOf.kindOf(itemType);
        this.itemType = itemType;
        this.name = name;
        Groups.ALL.add(this);
    }

    public String kind() {
        return this.kind;
    }

    public String name() {
        return this.name;
    }

    public Class<E> itemType() {
        return this.itemType;
    }

    public List<E> items() {
        return Collections.unmodifiableList(this.items);
    }

    public GroupStats stats() {
        return this.stats;
    }

    private void checkType(E element) {
        U.notNull(element, (String)"group element", (Object[])new Object[0]);
        U.must((boolean)this.itemType.isAssignableFrom(element.getClass()));
    }

    private void checkDuplicates(E element) {
        U.must((!this.items.contains(element) ? 1 : 0) != 0, (String)"The item is already in the group!");
    }

    public void add(E element) {
        this.checkType(element);
        this.checkDuplicates(element);
        this.items.add(element);
        this.stats.added.incrementAndGet();
    }

    public void add(int index, E element) {
        this.checkType(element);
        this.checkDuplicates(element);
        this.items.add(index, element);
        this.stats.added.incrementAndGet();
    }

    public E set(int index, E element) {
        this.checkType(element);
        this.checkDuplicates(element);
        return (E)((Manageable)this.items.set(index, element));
    }

    public E get(int index) {
        return (E)((Manageable)this.items.get(index));
    }

    public E get(String id) {
        E item = this.find(id);
        U.must((item != null ? 1 : 0) != 0, (String)"Cannot find item with id='%s'!", (Object)id);
        return item;
    }

    public E find(String id) {
        U.notNull((Object)id, (String)"id", (Object[])new Object[0]);
        for (Manageable item : this.items) {
            if (!U.eq((Object)id, (Object)item.id())) continue;
            return (E)item;
        }
        return null;
    }

    public E remove(int index) {
        return (E)((Manageable)this.items.remove(index));
    }

    public int indexOf(E element) {
        this.checkType(element);
        return this.items.indexOf(element);
    }

    public void clear() {
        this.items.clear();
    }

    public boolean remove(E element) {
        this.checkType(element);
        return this.items.remove(element);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean contains(E element) {
        this.checkType(element);
        return this.items.contains(element);
    }

    public String toString() {
        return "GroupOf{name='" + this.name + '\'' + ", size=" + this.items.size() + ", stats=" + (Object)((Object)this.stats) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GroupOf groupOf = (GroupOf)((Object)o);
        if (!this.itemType.equals(groupOf.itemType)) {
            return false;
        }
        return this.name.equals(groupOf.name);
    }

    public int hashCode() {
        int result = this.itemType.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

