/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.process;

import java.util.Set;
import org.rapidoid.activity.AbstractLoopThread;
import org.rapidoid.collection.Coll;
import org.rapidoid.process.ProcessHandle;

public class ProcessCrawlerThread
extends AbstractLoopThread {
    private final Set<ProcessHandle> handles;

    ProcessCrawlerThread(Set<ProcessHandle> handles) {
        super("process-crawler");
        this.setDaemon(true);
        this.handles = handles;
    }

    @Override
    protected void loop() {
        for (ProcessHandle handle : Coll.copyOf(this.handles)) {
            this.visit(handle);
        }
    }

    private void visit(ProcessHandle handle) {
        if (!handle.isAlive() && handle.finishedAt() == null) {
            handle.onTerminated();
        }
    }
}

