/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.serialize;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.rapidoid.cls.AbstractTypeSpecificFactory;
import org.rapidoid.cls.TypeKind;
import org.rapidoid.serialize.Ser;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.TUUID;

public class TypeSpecificDeserializer
extends AbstractTypeSpecificFactory<ByteBuffer> {
    public Object deserialize(ByteBuffer buf) {
        return this.create(buf);
    }

    @Override
    public Object create(ByteBuffer buf) {
        TypeKind kind = Ser.kind(Msc.ubyte(buf.get()));
        return super.create(buf, kind);
    }

    @Override
    public Object objectValue(ByteBuffer buf) {
        throw U.rte((String)"?");
    }

    @Override
    public boolean booleanValue(ByteBuffer buf) {
        return Ser.byte2bool(buf.get());
    }

    @Override
    public byte byteValue(ByteBuffer buf) {
        return buf.get();
    }

    @Override
    public short shortValue(ByteBuffer buf) {
        return buf.getShort();
    }

    @Override
    public char charValue(ByteBuffer buf) {
        return buf.getChar();
    }

    @Override
    public int intValue(ByteBuffer buf) {
        return buf.getInt();
    }

    @Override
    public long longValue(ByteBuffer buf) {
        return buf.getLong();
    }

    @Override
    public float floatValue(ByteBuffer buf) {
        return buf.getFloat();
    }

    @Override
    public double doubleValue(ByteBuffer buf) {
        return buf.getDouble();
    }

    @Override
    public String string(ByteBuffer buf) {
        return new String(Ser.readBytes(buf));
    }

    @Override
    public Date date(ByteBuffer buf) {
        return new Date(this.longValue(buf));
    }

    @Override
    public UUID uuid(ByteBuffer buf) {
        return new UUID(this.longValue(buf), this.longValue(buf));
    }

    @Override
    public TUUID tuuid(ByteBuffer buf) {
        return new TUUID(this.longValue(buf), this.longValue(buf), this.longValue(buf));
    }

    @Override
    public boolean[] booleanArr(ByteBuffer buf) {
        int len = Ser.readNum(buf);
        boolean[] arr = new boolean[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.booleanValue(buf);
        }
        return arr;
    }

    @Override
    public byte[] byteArr(ByteBuffer buf) {
        int len = Ser.readNum(buf);
        byte[] bytes = new byte[len];
        buf.get(bytes);
        return bytes;
    }

    @Override
    public short[] shortArr(ByteBuffer buf) {
        int len = Ser.readNum(buf);
        short[] arr = new short[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.shortValue(buf);
        }
        return arr;
    }

    @Override
    public char[] charArr(ByteBuffer buf) {
        int len = Ser.readNum(buf);
        char[] arr = new char[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.charValue(buf);
        }
        return arr;
    }

    @Override
    public int[] intArr(ByteBuffer buf) {
        int len = Ser.readNum(buf);
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.intValue(buf);
        }
        return arr;
    }

    @Override
    public long[] longArr(ByteBuffer buf) {
        int len = Ser.readNum(buf);
        long[] arr = new long[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.longValue(buf);
        }
        return arr;
    }

    @Override
    public float[] floatArr(ByteBuffer buf) {
        int len = Ser.readNum(buf);
        float[] arr = new float[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.floatValue(buf);
        }
        return arr;
    }

    @Override
    public double[] doubleArr(ByteBuffer buf) {
        int len = Ser.readNum(buf);
        double[] arr = new double[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.doubleValue(buf);
        }
        return arr;
    }

    @Override
    public List<?> list(ByteBuffer buf) {
        List list = U.list();
        int size = Ser.readNum(buf);
        for (int i = 0; i < size; ++i) {
            list.add(this.create(buf));
        }
        return list;
    }

    @Override
    public Set<?> set(ByteBuffer buf) {
        Set set = U.set();
        int size = Ser.readNum(buf);
        for (int i = 0; i < size; ++i) {
            set.add(this.create(buf));
        }
        return set;
    }

    @Override
    public Map<?, ?> map(ByteBuffer buf) {
        Map map = U.map();
        int size = Ser.readNum(buf);
        for (int i = 0; i < size; ++i) {
            Object key = this.create(buf);
            Object value = this.create(buf);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Object[] objectArr(ByteBuffer buf) {
        int size = Ser.readNum(buf);
        Object[] arr = new Object[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = this.create(buf);
        }
        return arr;
    }
}

