/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Rnd;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.SimpleBucket;
import org.rapidoid.util.SimpleList;

public class SimpleHashTable<T>
extends RapidoidThing {
    private static final int DEFAULT_BUCKET_SIZE = 8;
    public final SimpleBucket<T>[] buckets;
    public final int factor;
    private final int hashMask;
    private final int xor = Rnd.rnd();

    public SimpleHashTable(int capacity, int bucketSize) {
        this(capacity, bucketSize, true);
    }

    public SimpleHashTable(int capacity, int bucketSize, boolean unbounded) {
        int factor;
        int width;
        int realCapacity;
        U.must((capacity >= 2 ? 1 : 0) != 0, (String)"The capacity is too small!");
        if (bucketSize <= 0) {
            bucketSize = 8;
        }
        U.must((capacity <= (realCapacity = (width = (int)Math.pow(2.0, factor = Msc.log2(Math.max(capacity / bucketSize, 1)))) * bucketSize) ? 1 : 0) != 0);
        this.buckets = new SimpleList[width];
        this.factor = factor;
        this.hashMask = Msc.bitMask(factor);
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = this.createBucket(bucketSize, unbounded);
        }
    }

    protected SimpleBucket<T> createBucket(int bucketSize, boolean unbounded) {
        U.must((boolean)unbounded, (String)"Only unbounded buckets are supported!");
        return new SimpleList(bucketSize);
    }

    public void put(long key, T value) {
        this.bucket(key).add(value);
    }

    public SimpleBucket<T> bucket(long key) {
        int index = this.index(key);
        return this.getBucketAt(index);
    }

    public SimpleBucket<T> getBucketAt(int index) {
        SimpleBucket<T> list;
        while ((list = this.buckets[index]) == null) {
        }
        return list;
    }

    public int index(long key) {
        return (int)((key ^ (long)this.xor) & (long)this.hashMask);
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.clearBucket(i);
        }
    }

    protected void clearBucket(int index) {
        this.getBucketAt(index).clear();
    }

    public int bucketCount() {
        return this.buckets.length;
    }
}

