/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.writable;

import org.rapidoid.RapidoidThing;
import org.rapidoid.writable.Writable;

public class WritableUtils
extends RapidoidThing {
    private static final String MIN_VALUE = "-9223372036854775808";

    public static void putNumAsText(Writable out, long n) {
        if (n >= 0L) {
            WritableUtils.writeDigits(out, n);
        } else if (n == Long.MIN_VALUE) {
            WritableUtils.writeAscii(out, MIN_VALUE);
        } else {
            out.writeByte((byte)45);
            WritableUtils.putNumAsText(out, -n);
        }
    }

    private static void writeDigits(Writable out, long n) {
        int digit = (int)(n % 10L);
        if (n >= 10L) {
            WritableUtils.writeDigits(out, n / 10L);
        }
        out.writeByte((byte)(digit + 48));
    }

    public static void writeAscii(Writable out, String s) {
        for (int i = 0; i < s.length(); ++i) {
            out.writeByte((byte)s.charAt(i));
        }
    }

    public static void writeAscii(Writable out, byte[] bytes) {
        out.writeBytes(bytes);
    }

    public static void writeUTF8(Writable out, String src) {
        int limit = src.length();
        for (int i = 0; i < limit; ++i) {
            char c = src.charAt(i);
            if (c < '\u0080') {
                out.writeByte((byte)c);
                continue;
            }
            if (c < '\u0800') {
                out.writeByte((byte)(0xC0 | c >> 6));
                out.writeByte((byte)(0x80 | c & 0x3F));
                continue;
            }
            if (Character.isSurrogate(c)) {
                if (Character.isHighSurrogate(c)) {
                    int next = i + 1;
                    if (next < limit) {
                        char nextChar = src.charAt(next);
                        if (Character.isLowSurrogate(nextChar)) {
                            int cp = Character.toCodePoint(c, nextChar);
                            out.writeByte((byte)(0xF0 | cp >> 18));
                            out.writeByte((byte)(0x80 | cp >> 12 & 0x3F));
                            out.writeByte((byte)(0x80 | cp >> 6 & 0x3F));
                            out.writeByte((byte)(0x80 | cp & 0x3F));
                            ++i;
                            continue;
                        }
                        out.writeByte((byte)63);
                        continue;
                    }
                    out.writeByte((byte)63);
                    continue;
                }
                out.writeByte((byte)63);
                continue;
            }
            out.writeByte((byte)(0xE0 | c >> 12));
            out.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            out.writeByte((byte)(0x80 | c & 0x3F));
        }
    }

    public static void writeUTF8HtmlEscaped(Writable out, String src) {
        int limit = src.length();
        for (int i = 0; i < limit; ++i) {
            char c = src.charAt(i);
            if (c < '\u0080') {
                switch (c) {
                    case '<': {
                        out.writeByte((byte)38);
                        out.writeByte((byte)108);
                        out.writeByte((byte)116);
                        out.writeByte((byte)59);
                        break;
                    }
                    case '>': {
                        out.writeByte((byte)38);
                        out.writeByte((byte)103);
                        out.writeByte((byte)116);
                        out.writeByte((byte)59);
                        break;
                    }
                    case '&': {
                        out.writeByte((byte)38);
                        out.writeByte((byte)97);
                        out.writeByte((byte)109);
                        out.writeByte((byte)112);
                        out.writeByte((byte)59);
                        break;
                    }
                    case '\"': {
                        out.writeByte((byte)38);
                        out.writeByte((byte)113);
                        out.writeByte((byte)117);
                        out.writeByte((byte)111);
                        out.writeByte((byte)116);
                        out.writeByte((byte)59);
                        break;
                    }
                    case '\'': {
                        out.writeByte((byte)38);
                        out.writeByte((byte)97);
                        out.writeByte((byte)112);
                        out.writeByte((byte)111);
                        out.writeByte((byte)115);
                        out.writeByte((byte)59);
                        break;
                    }
                    default: {
                        out.writeByte((byte)c);
                        break;
                    }
                }
                continue;
            }
            if (c < '\u0800') {
                out.writeByte((byte)(0xC0 | c >> 6));
                out.writeByte((byte)(0x80 | c & 0x3F));
                continue;
            }
            if (Character.isSurrogate(c)) {
                if (Character.isHighSurrogate(c)) {
                    int next = i + 1;
                    if (next < limit) {
                        char nextChar = src.charAt(next);
                        if (Character.isLowSurrogate(nextChar)) {
                            int cp = Character.toCodePoint(c, nextChar);
                            out.writeByte((byte)(0xF0 | cp >> 18));
                            out.writeByte((byte)(0x80 | cp >> 12 & 0x3F));
                            out.writeByte((byte)(0x80 | cp >> 6 & 0x3F));
                            out.writeByte((byte)(0x80 | cp & 0x3F));
                            ++i;
                            continue;
                        }
                        out.writeByte((byte)63);
                        continue;
                    }
                    out.writeByte((byte)63);
                    continue;
                }
                out.writeByte((byte)63);
                continue;
            }
            out.writeByte((byte)(0xE0 | c >> 12));
            out.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            out.writeByte((byte)(0x80 | c & 0x3F));
        }
    }
}

