/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ctx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.ctx.CtxData;
import org.rapidoid.ctx.CtxMetadata;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.UserInfo;
import org.rapidoid.job.Jobs;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class Ctx
implements CtxMetadata {
    private static final AtomicLong ID_COUNTER = new AtomicLong();
    private final long id = ID_COUNTER.incrementAndGet();
    private final String tag;
    private volatile UserInfo user;
    private volatile Object exchange;
    private volatile Object app;
    private volatile int referenceCounter = 1;
    private volatile ThreadLocal<Object> persisters = new ThreadLocal();
    private volatile boolean closed = false;
    private final List<Object> allPersisters = Collections.synchronizedList(new ArrayList(5));
    private final Map<Object, Object> extras = U.synchronizedMap();

    Ctx(String tag) {
        this.tag = tag;
    }

    public UserInfo user() {
        this.ensureNotClosed();
        return this.user;
    }

    public void setUser(UserInfo user) {
        this.ensureNotClosed();
        this.user = user;
    }

    public <T> T exchange() {
        this.ensureNotClosed();
        return (T)this.exchange;
    }

    public void setExchange(Object exchange) {
        this.ensureNotClosed();
        this.exchange = exchange;
    }

    public <T> T app() {
        this.ensureNotClosed();
        return (T)this.app;
    }

    public void setApp(Object app) {
        this.ensureNotClosed();
        this.app = app;
    }

    public synchronized <P> P persister() {
        this.ensureNotClosed();
        Object persister = this.persisters.get();
        if (persister == null) {
            persister = Ctxs.createPersister();
            this.persisters.set(persister);
            this.allPersisters.add(persister);
        }
        return (P)persister;
    }

    public synchronized Ctx span() {
        this.ensureNotClosed();
        ++this.referenceCounter;
        Log.debug((String)"Spanning context", (String)"ctx", (Object)this);
        return this;
    }

    synchronized void close() {
        this.ensureNotClosed();
        Log.debug((String)"Closing context", (String)"ctx", (Object)this);
        --this.referenceCounter;
        if (this.referenceCounter == 0) {
            this.clear();
        } else if (this.referenceCounter < 0) {
            throw new IllegalStateException("Reference counter < 0 for context: " + this);
        }
    }

    private synchronized void clear() {
        this.ensureNotClosed();
        Log.debug((String)"Clearing context", (String)"ctx", (Object)this);
        this.referenceCounter = 0;
        this.user = null;
        this.exchange = null;
        this.app = null;
        this.persisters = null;
        for (Object persister : this.allPersisters) {
            Ctxs.closePersister(persister);
        }
        this.allPersisters.clear();
        this.extras.clear();
        this.closed = true;
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new RuntimeException("The context is closed!");
        }
    }

    public String toString() {
        int maxLen = 10;
        return this.prefixed("Ctx [id=" + this.id + ", tag=" + this.tag + ", user=" + this.user + ", exchange=" + this.exchange + ", app=" + this.app + ", referenceCounter=" + this.referenceCounter + ", persisters=" + this.persisters + ", closed=" + this.closed + ", allPersisters=" + (this.allPersisters != null ? this.toString(this.allPersisters, 10) : null) + ", extras=" + (this.extras != null ? this.toString(this.extras.entrySet(), 10) : null) + "]");
    }

    private String prefixed(String asStr) {
        String isClosed = this.closed ? " <CLOSED>" : "";
        String prefix = "Ctx#" + this.id + ":" + this.tag + isClosed;
        return prefix + " " + asStr;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T> T executeInCtx(CtxData cd, Callable<T> action) {
        Ctx ctx = Ctxs.open("call");
        ctx.setApp(cd.app());
        ctx.setExchange(null);
        ctx.setUser(new UserInfo(cd.username(), cd.roles()));
        U.assign(ctx.extras(), cd.extras());
        try {
            Object object = Lmbd.call(action);
            return (T)object;
        }
        finally {
            Ctxs.close();
        }
    }

    public static synchronized void executeInCtx(String tag, Runnable action) {
        Ctxs.open(tag);
        try {
            Jobs.execute(action);
        }
        finally {
            Ctxs.close();
        }
    }

    public Map<Object, Object> extras() {
        this.ensureNotClosed();
        return this.extras;
    }

    public boolean isLoggedIn() {
        return this.user() != null;
    }

    public String username() {
        return this.isLoggedIn() ? this.user().username : null;
    }

    public String tag() {
        return this.tag;
    }
}

