/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ctx;

import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.PersisterProvider;
import org.rapidoid.log.Log;

public class Ctxs {
    private static final ThreadLocal<Ctx> CTXS = new ThreadLocal();
    private static volatile PersisterProvider persisterProvider = null;

    private Ctxs() {
    }

    public static Ctx get() {
        return CTXS.get();
    }

    public static Ctx ctx() {
        Ctx ctx = Ctxs.get();
        if (ctx == null) {
            throw new IllegalStateException("App ctx wasn't set!");
        }
        return ctx;
    }

    public static boolean hasContext() {
        return Ctxs.get() != null;
    }

    public static void attach(Ctx ctx) {
        if (!Ctxs.hasContext()) {
            if (ctx != null) {
                CTXS.set(ctx);
            }
        } else {
            throw new IllegalStateException("The context was already opened: " + Ctxs.ctx());
        }
    }

    public static Ctx open(String tag) {
        Ctx ctx = new Ctx(tag);
        Log.debug((String)"Opening context", (String)"ctx", (Object)ctx);
        Ctxs.attach(ctx);
        return ctx;
    }

    public static void close() {
        block4: {
            try {
                Ctx ctx = Ctxs.get();
                if (ctx != null) {
                    ctx.close();
                    break block4;
                }
                throw new RuntimeException("There is no opened context!");
            }
            finally {
                CTXS.remove();
            }
        }
    }

    public static PersisterProvider getPersisterProvider() {
        return persisterProvider;
    }

    public static void setPersisterProvider(PersisterProvider persisterProvider) {
        Ctxs.persisterProvider = persisterProvider;
    }

    public static Object createPersister() {
        return persisterProvider.openPersister();
    }

    public static void closePersister(Object persister) {
        persisterProvider.closePersister(persister);
    }
}

