/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ctx;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.u.U;

public class Roles {
    public static final String ANYBODY = "anybody";
    public static final String ADMIN = "admin";
    public static final String MANAGER = "manager";
    public static final String MODERATOR = "moderator";
    public static final String LOGGED_IN = "logged_in";
    public static final String OWNER = "owner";
    public static final String AUTHOR = "author";
    public static final String SHARED_WITH = "shared_with";
    public static final String RESTARTER = "restarter";
    public static final String ANONYMOUS = "anonymous";
    public static final List<String> COMMON_ROLES = Collections.unmodifiableList(Arrays.asList("admin", "manager", "moderator", "logged_in", "owner", "restarter"));
    public static final Set<String> ROLES_ANONYMOUS = U.set((Object[])new String[]{"anonymous"});
    public static final Set<String> ROLES_LOGGED_IN = U.set((Object[])new String[]{"logged_in"});

    public static Set<String> getRolesFor(String username) {
        if (U.isEmpty((String)username)) {
            return ROLES_ANONYMOUS;
        }
        Config users = Conf.users();
        Map user = (Map)users.get(username);
        if (user == null) {
            return ROLES_LOGGED_IN;
        }
        Object roles = U.cast(user.get("roles"));
        if (U.isCollection((Object)roles)) {
            Set roleSet = U.set();
            for (String role : (Collection)roles) {
                roleSet.add(role.toLowerCase());
            }
            return roleSet;
        }
        if (roles instanceof String) {
            String role = (String)roles;
            return U.set((Object[])new String[]{role.toLowerCase()});
        }
        return ROLES_LOGGED_IN;
    }
}

