/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ctx;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.rapidoid.ctx.Roles;
import org.rapidoid.u.U;

public class UserInfo
implements Serializable {
    private static final String USERNAME = "_USER.USERNAME";
    private static final String EMAIL = "_USER.EMAIL";
    private static final String NAME = "_USER.NAME";
    private static final long serialVersionUID = 7062732348562440194L;
    private static final UserInfo ANONYMOUS = new UserInfo("anonymous", null, "Anonymous", null, null, Roles.ROLES_ANONYMOUS);
    public final String username;
    public final String email;
    public final String name;
    public final String oauthId;
    public final String oauthProvider;
    public volatile Set<String> roles;
    public volatile Map<String, Boolean> is;

    public UserInfo(String username) {
        this(username, username, username);
    }

    public UserInfo(String username, Set<String> roles) {
        this(username, username, username, null, null, roles);
    }

    public UserInfo(String username, String email, String name) {
        this(username, email, name, null, null);
    }

    public UserInfo(String username, String email, String name, String oauthId, String oauthProvider) {
        this(username, email, name, oauthId, oauthProvider, Roles.getRolesFor(username));
    }

    public UserInfo(String username, String email, String name, String oauthId, String oauthProvider, Set<String> roles) {
        this.username = username;
        this.email = email;
        this.name = name;
        this.oauthId = oauthId;
        this.oauthProvider = oauthProvider;
        this.roles = roles;
        this.is = UserInfo.rolesMap(roles);
    }

    private static Map<String, Boolean> rolesMap(Set<String> roles) {
        Map rolesMap = U.map();
        for (String role : U.safe(roles)) {
            rolesMap.put(role, true);
        }
        return rolesMap;
    }

    public static UserInfo from(Map<String, ?> scope) {
        String username = (String)scope.get(USERNAME);
        String email = (String)scope.get(EMAIL);
        String name = (String)scope.get(NAME);
        return username != null ? new UserInfo(username, email, name) : ANONYMOUS;
    }

    public void saveTo(Map<String, Serializable> scope) {
        scope.put(USERNAME, (Serializable)((Object)this.username));
        scope.put(EMAIL, (Serializable)((Object)this.email));
        scope.put(NAME, (Serializable)((Object)this.name));
    }

    public String toString() {
        return "UserInfo [username=" + this.username + ", email=" + this.email + ", name=" + this.name + ", oauthId=" + this.oauthId + ", oauthProvider=" + this.oauthProvider + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

