/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class ContextPreservingJobWrapper
implements Runnable {
    private final Runnable job;
    private final Ctx ctx;

    public ContextPreservingJobWrapper(Runnable job, Ctx ctx) {
        this.job = job;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        U.must((!Ctxs.hasContext() ? 1 : 0) != 0, (String)"Detected context leak!");
        try {
            if (this.ctx != null) {
                Ctxs.attach(this.ctx);
            } else {
                Ctxs.open("job");
                Log.debug((String)"Opening new context");
            }
        }
        catch (Throwable e) {
            Log.error((String)"Job context initialization failed!", (Throwable)e);
            throw U.rte((String)"Job context initialization failed!", (Throwable)e);
        }
        try {
            this.job.run();
        }
        catch (Throwable e) {
            Log.error((String)"Job execution failed!", (Throwable)e);
            throw U.rte((String)"Job execution failed!", (Throwable)e);
        }
        finally {
            Ctxs.close();
        }
    }
}

