/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.rapidoid.activity.RapidoidThreadFactory;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.config.Conf;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.JobStatusListener;
import org.rapidoid.job.CallbackExecutorJob;
import org.rapidoid.job.ContextPreservingJobWrapper;

public class Jobs {
    private static ScheduledExecutorService SCHEDULER;
    private static Executor EXECUTOR;

    private Jobs() {
    }

    public static synchronized ScheduledExecutorService scheduler() {
        if (SCHEDULER == null) {
            int threads = Conf.option((String)"threads", (int)100);
            SCHEDULER = Executors.newScheduledThreadPool(threads / 2, (ThreadFactory)new RapidoidThreadFactory("jobs"));
        }
        return SCHEDULER;
    }

    public static synchronized Executor executor() {
        if (EXECUTOR == null) {
            int threads = Conf.option((String)"threads", (int)100);
            EXECUTOR = Executors.newFixedThreadPool(threads);
        }
        return EXECUTOR;
    }

    public static ScheduledFuture<?> schedule(Runnable job, long delay, TimeUnit unit) {
        return Jobs.scheduler().schedule(Jobs.wrap(job), delay, unit);
    }

    public static <T> ScheduledFuture<?> schedule(Callable<T> job, long delay, TimeUnit unit, Callback<T> callback) {
        return Jobs.schedule(Jobs.callbackJob(job, callback), delay, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable job, long initialDelay, long period, TimeUnit unit) {
        return Jobs.scheduler().scheduleAtFixedRate(Jobs.wrap(job), initialDelay, period, unit);
    }

    public static <T> ScheduledFuture<?> scheduleAtFixedRate(Callable<T> job, long initialDelay, long period, TimeUnit unit, Callback<T> callback) {
        return Jobs.scheduleAtFixedRate(Jobs.callbackJob(job, callback), initialDelay, period, unit);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable job, long initialDelay, long delay, TimeUnit unit) {
        return Jobs.scheduler().scheduleWithFixedDelay(Jobs.wrap(job), initialDelay, delay, unit);
    }

    public static <T> ScheduledFuture<?> scheduleWithFixedDelay(Callable<T> job, long initialDelay, long delay, TimeUnit unit, Callback<T> callback) {
        return Jobs.scheduleWithFixedDelay(Jobs.callbackJob(job, callback), initialDelay, delay, unit);
    }

    public static void execute(Runnable job) {
        Jobs.executor().execute(Jobs.wrap(job));
    }

    public static <T> void execute(Callable<T> job, Callback<T> callback) {
        Jobs.execute(Jobs.callbackJob(job, callback));
    }

    public static Runnable wrap(Runnable job) {
        Ctx ctx = Ctxs.get();
        if (ctx != null) {
            Object x = ctx.exchange();
            if (x instanceof JobStatusListener) {
                ((JobStatusListener)x).onAsync();
            }
            ctx = ctx.span();
        }
        return new ContextPreservingJobWrapper(job, ctx);
    }

    public static <T> void callIfNotNull(Callback<T> callback, T result, Throwable error) {
        if (callback != null) {
            Jobs.execute(new CallbackExecutorJob<T>(callback, result, error));
        }
    }

    public static <T> void call(Callback<T> callback, T result, Throwable error) {
        Jobs.execute(new CallbackExecutorJob<T>(callback, result, error));
    }

    private static <T> Runnable callbackJob(final Callable<T> job, final Callback<T> callback) {
        return new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = job.call();
                }
                catch (Throwable e) {
                    Jobs.call(callback, null, e);
                    return;
                }
                Jobs.call(callback, result, null);
            }
        };
    }
}

