/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.customize;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Config;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.http.HttpWrapper;
import org.rapidoid.http.Req;
import org.rapidoid.http.customize.BeanParameterFactory;
import org.rapidoid.http.customize.BeanValidator;
import org.rapidoid.http.customize.EntityManagerFactoryProvider;
import org.rapidoid.http.customize.EntityManagerProvider;
import org.rapidoid.http.customize.ErrorHandler;
import org.rapidoid.http.customize.HttpRequestBodyParser;
import org.rapidoid.http.customize.HttpResponseRenderer;
import org.rapidoid.http.customize.LoginProvider;
import org.rapidoid.http.customize.PageDecorator;
import org.rapidoid.http.customize.ResourceLoader;
import org.rapidoid.http.customize.RolesProvider;
import org.rapidoid.http.customize.SessionManager;
import org.rapidoid.http.customize.StaticFilesSecurity;
import org.rapidoid.http.customize.ViewResolver;
import org.rapidoid.http.customize.defaults.DefaultTemplateLoader;
import org.rapidoid.http.impl.ErrorHandlerResolver;
import org.rapidoid.setup.My;
import org.rapidoid.u.U;
import org.rapidoid.util.ByType;

public class Customization
extends RapidoidThing {
    private final String name;
    private final Customization defaults;
    private final Config config;
    private final ByType<Throwable, ErrorHandler> errorHandlers = ByType.create();
    private final ErrorHandlerResolver errorHandlerResolver = new ErrorHandlerResolver();
    private volatile String[] staticFilesPath;
    private volatile ErrorHandler errorHandler;
    private volatile ViewResolver viewResolver;
    private volatile PageDecorator pageDecorator;
    private volatile HttpResponseRenderer jsonResponseRenderer;
    private volatile HttpRequestBodyParser jsonRequestBodyParser;
    private volatile HttpResponseRenderer xmlResponseRenderer;
    private volatile HttpRequestBodyParser xmlRequestBodyParser;
    private volatile BeanParameterFactory beanParameterFactory;
    private volatile LoginProvider loginProvider;
    private volatile RolesProvider rolesProvider;
    private volatile BeanValidator validator;
    private volatile ObjectMapper objectMapper;
    private volatile XmlMapper xmlMapper;
    private volatile EntityManagerProvider entityManagerProvider;
    private volatile EntityManagerFactoryProvider entityManagerFactoryProvider;
    private volatile SessionManager sessionManager;
    private volatile StaticFilesSecurity staticFilesSecurity;
    private volatile HttpWrapper[] wrappers;
    private volatile ResourceLoader templateLoader;

    public Customization(String name, Customization defaults, Config config) {
        this.name = name;
        this.defaults = defaults;
        this.config = config;
        this.reset();
    }

    public synchronized void reset() {
        this.staticFilesPath = null;
        this.errorHandler = null;
        this.viewResolver = null;
        this.pageDecorator = null;
        this.jsonResponseRenderer = null;
        this.jsonRequestBodyParser = null;
        this.xmlResponseRenderer = null;
        this.xmlRequestBodyParser = null;
        this.beanParameterFactory = null;
        this.loginProvider = null;
        this.rolesProvider = null;
        this.validator = null;
        this.objectMapper = null;
        this.xmlMapper = null;
        this.entityManagerProvider = null;
        this.entityManagerFactoryProvider = null;
        this.sessionManager = null;
        this.errorHandlers.reset();
        this.staticFilesSecurity = null;
        this.wrappers = null;
        this.templateLoader = null;
    }

    public static Customization of(Req req) {
        assert (Customization.inValidContext(req));
        return req != null ? req.custom() : My.custom();
    }

    private static boolean inValidContext(Req req) {
        Ctx ctx = Ctxs.get();
        Req ctxReq = ctx != null ? (Req)ctx.exchange() : null;
        U.must((ctx == null || !ctx.isClosed() ? 1 : 0) != 0, (String)"The context for request (%s) is closed!");
        U.must((req == ctxReq ? 1 : 0) != 0, (String)"The customization request (%s) doesn't match the context request (%s)!", (Object)req, (Object)ctxReq);
        return true;
    }

    public String name() {
        return this.name;
    }

    public Customization defaults() {
        return this.defaults;
    }

    public Config config() {
        return this.config;
    }

    public String[] staticFilesPath() {
        return this.staticFilesPath != null || this.defaults == null ? this.staticFilesPath : this.defaults.staticFilesPath();
    }

    public Customization staticFilesPath(String ... staticFilesPath) {
        this.staticFilesPath = staticFilesPath;
        return this;
    }

    public String[] templatesPath() {
        if (this.templateLoader != null || this.defaults == null) {
            U.must((boolean)(this.templateLoader instanceof DefaultTemplateLoader), (String)"A custom template loader was configured!");
            return ((DefaultTemplateLoader)this.templateLoader).templatesPath();
        }
        return this.defaults.templatesPath();
    }

    public Customization templatesPath(String ... templatesPath) {
        this.templateLoader = new DefaultTemplateLoader(templatesPath);
        return this;
    }

    public ErrorHandler errorHandler() {
        return this.errorHandler != null || this.defaults == null ? this.errorHandler : this.defaults.errorHandler();
    }

    public Customization errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public ViewResolver viewResolver() {
        return this.viewResolver != null || this.defaults == null ? this.viewResolver : this.defaults.viewResolver();
    }

    public Customization viewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
        return this;
    }

    public PageDecorator pageDecorator() {
        return this.pageDecorator != null || this.defaults == null ? this.pageDecorator : this.defaults.pageDecorator();
    }

    public Customization pageDecorator(PageDecorator pageDecorator) {
        this.pageDecorator = pageDecorator;
        return this;
    }

    public HttpResponseRenderer jsonResponseRenderer() {
        return this.jsonResponseRenderer != null || this.defaults == null ? this.jsonResponseRenderer : this.defaults.jsonResponseRenderer();
    }

    public Customization jsonResponseRenderer(HttpResponseRenderer jsonResponseRenderer) {
        this.jsonResponseRenderer = jsonResponseRenderer;
        return this;
    }

    public HttpResponseRenderer xmlResponseRenderer() {
        return this.xmlResponseRenderer != null || this.defaults == null ? this.xmlResponseRenderer : this.defaults.xmlResponseRenderer();
    }

    public Customization xmlResponseRenderer(HttpResponseRenderer xmlResponseRenderer) {
        this.xmlResponseRenderer = xmlResponseRenderer;
        return this;
    }

    public BeanParameterFactory beanParameterFactory() {
        return this.beanParameterFactory != null || this.defaults == null ? this.beanParameterFactory : this.defaults.beanParameterFactory();
    }

    public Customization beanParameterFactory(BeanParameterFactory beanParameterFactory) {
        this.beanParameterFactory = beanParameterFactory;
        return this;
    }

    public LoginProvider loginProvider() {
        return this.loginProvider != null || this.defaults == null ? this.loginProvider : this.defaults.loginProvider();
    }

    public Customization loginProvider(LoginProvider loginProvider) {
        this.loginProvider = loginProvider;
        return this;
    }

    public RolesProvider rolesProvider() {
        return this.rolesProvider != null || this.defaults == null ? this.rolesProvider : this.defaults.rolesProvider();
    }

    public Customization rolesProvider(RolesProvider rolesProvider) {
        this.rolesProvider = rolesProvider;
        return this;
    }

    public BeanValidator validator() {
        return this.validator != null || this.defaults == null ? this.validator : this.defaults.validator();
    }

    public Customization validator(BeanValidator validator) {
        this.validator = validator;
        return this;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper != null || this.defaults == null ? this.objectMapper : this.defaults.objectMapper();
    }

    public Customization objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public XmlMapper xmlMapper() {
        return this.xmlMapper != null || this.defaults == null ? this.xmlMapper : this.defaults.xmlMapper();
    }

    public Customization xmlMapper(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
        return this;
    }

    public EntityManagerProvider entityManagerProvider() {
        return this.entityManagerProvider != null || this.defaults == null ? this.entityManagerProvider : this.defaults.entityManagerProvider();
    }

    public Customization entityManagerProvider(EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
        return this;
    }

    public EntityManagerFactoryProvider entityManagerFactoryProvider() {
        return this.entityManagerFactoryProvider != null || this.defaults == null ? this.entityManagerFactoryProvider : this.defaults.entityManagerFactoryProvider();
    }

    public Customization entityManagerFactoryProvider(EntityManagerFactoryProvider entityManagerFactoryProvider) {
        this.entityManagerFactoryProvider = entityManagerFactoryProvider;
        return this;
    }

    public HttpRequestBodyParser jsonRequestBodyParser() {
        return this.jsonRequestBodyParser != null || this.defaults == null ? this.jsonRequestBodyParser : this.defaults.jsonRequestBodyParser();
    }

    public Customization jsonRequestBodyParser(HttpRequestBodyParser jsonRequestBodyParser) {
        this.jsonRequestBodyParser = jsonRequestBodyParser;
        return this;
    }

    public HttpRequestBodyParser xmlRequestBodyParser() {
        return this.xmlRequestBodyParser != null || this.defaults == null ? this.xmlRequestBodyParser : this.defaults.xmlRequestBodyParser();
    }

    public Customization xmlRequestBodyParser(HttpRequestBodyParser xmlRequestBodyParser) {
        this.xmlRequestBodyParser = xmlRequestBodyParser;
        return this;
    }

    public SessionManager sessionManager() {
        return this.sessionManager != null || this.defaults == null ? this.sessionManager : this.defaults.sessionManager();
    }

    public Customization sessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public ByType<Throwable, ErrorHandler> errorHandlers() {
        return this.errorHandlers;
    }

    public ErrorHandler findErrorHandlerByType(Throwable error) {
        return this.errorHandlerResolver.findErrorHandlerByType(this, error);
    }

    public StaticFilesSecurity staticFilesSecurity() {
        return this.staticFilesSecurity != null || this.defaults == null ? this.staticFilesSecurity : this.defaults.staticFilesSecurity();
    }

    public Customization staticFilesSecurity(StaticFilesSecurity staticFilesSecurity) {
        this.staticFilesSecurity = staticFilesSecurity;
        return this;
    }

    public HttpWrapper[] wrappers() {
        return this.wrappers != null || this.defaults == null ? this.wrappers : this.defaults.wrappers();
    }

    public Customization wrappers(HttpWrapper ... wrappers) {
        this.wrappers = wrappers;
        return this;
    }

    public ResourceLoader templateLoader() {
        return this.templateLoader != null || this.defaults == null ? this.templateLoader : this.defaults.templateLoader();
    }

    public Customization templateLoader(ResourceLoader templateLoader) {
        this.templateLoader = templateLoader;
        return this;
    }

    public String toString() {
        return "Customization{name='" + this.name + '\'' + (this.defaults != null ? ", defaults=" + (Object)((Object)this.defaults) : "") + '}';
    }
}

