/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import java.util.concurrent.Callable;
import org.rapidoid.ctx.With;
import org.rapidoid.http.FastHttp;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpWrapper;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.handler.AbstractDecoratingHttpHandler;
import org.rapidoid.http.handler.AbstractHttpHandlerDecorator;
import org.rapidoid.http.handler.HandlerInvocation;
import org.rapidoid.http.handler.HttpWrappers;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.LogLevel;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.u.U;
import org.rapidoid.util.LazyInit;

public class HttpManagedHandlerDecorator
extends AbstractHttpHandlerDecorator {
    private static final String CTX_TAG_HANDLER = "handler";
    private final RouteOptions options;
    private final LazyInit<HttpWrapper[]> wrappers;

    HttpManagedHandlerDecorator(AbstractDecoratingHttpHandler handler, final FastHttp http, final RouteOptions options) {
        super(handler, http);
        this.options = options;
        this.wrappers = new LazyInit((Callable)new Callable<HttpWrapper[]>(){

            @Override
            public HttpWrapper[] call() {
                return HttpWrappers.assembleWrappers(http, options);
            }
        });
    }

    @Override
    public final HttpStatus handle(Channel ctx, boolean isKeepAlive, Req req) {
        if (!ctx.isAsync()) {
            ctx.async();
        }
        this.execHandlerJob(ctx, isKeepAlive, this.options.contentType(), req);
        return HttpStatus.ASYNC;
    }

    private void execHandlerJob(final Channel channel, final boolean isKeepAlive, final MediaType contentType, final Req req) {
        With.tag((String)CTX_TAG_HANDLER).exchange((Object)req).run(new Runnable(){

            @Override
            public void run() {
                try {
                    req.response().view(HttpManagedHandlerDecorator.this.options.view()).contentType(HttpManagedHandlerDecorator.this.options.contentType()).mvc(HttpManagedHandlerDecorator.this.options.mvc());
                    HttpManagedHandlerDecorator.this.handleWithWrappers(channel, isKeepAlive, contentType, req, (HttpWrapper[])HttpManagedHandlerDecorator.this.wrappers.get());
                }
                catch (Throwable e) {
                    HttpManagedHandlerDecorator.this.handleError(req, e);
                }
            }
        });
    }

    private void handleWithWrappers(Channel channel, boolean isKeepAlive, MediaType contentType, Req req, HttpWrapper[] wrappers) {
        Object result;
        try {
            result = !U.isEmpty((Object[])wrappers) ? this.wrap(channel, isKeepAlive, req, 0, wrappers) : this.handleReqAndPostProcess(channel, isKeepAlive, req);
        }
        catch (Throwable e) {
            result = e;
        }
        this.complete(channel, isKeepAlive, contentType, req, result);
    }

    private Object wrap(final Channel channel, final boolean isKeepAlive, final Req req, final int index, final HttpWrapper[] wrappers) throws Exception {
        HttpWrapper wrapper = wrappers[index];
        HandlerInvocation invocation = new HandlerInvocation(){

            @Override
            public Object invoke() throws Exception {
                return this.invokeNext();
            }

            @Override
            public Object invokeAndTransformResult(Mapper<Object, Object> transformation) throws Exception {
                Object result = this.invokeNext();
                if (result instanceof Throwable) {
                    return result;
                }
                return this.transform(transformation, result);
            }

            @Override
            public Object invokeAndTransformResultCatchingErrors(Mapper<Object, Object> transformation) {
                Object resultOrError;
                try {
                    resultOrError = this.invokeNext();
                }
                catch (Throwable e) {
                    resultOrError = e;
                }
                try {
                    return this.transform(transformation, resultOrError);
                }
                catch (Throwable e) {
                    return e;
                }
            }

            private Object invokeNext() throws Exception {
                int next = index + 1;
                Object result = next < wrappers.length ? HttpManagedHandlerDecorator.this.wrap(channel, isKeepAlive, req, next, wrappers) : HttpManagedHandlerDecorator.this.handleReqAndPostProcess(channel, isKeepAlive, req);
                return result;
            }

            private Object transform(Mapper<Object, Object> transformation, Object resultOrError) throws Exception {
                U.notNull(transformation, (String)"transformation", (Object[])new Object[0]);
                if (HttpWrappers.shouldTransform(resultOrError)) {
                    return transformation.map(resultOrError);
                }
                Resp resp = req.response();
                if (HttpWrappers.shouldTransform(resp.result())) {
                    resp.result(transformation.map(resp.result()));
                }
                return resultOrError;
            }
        };
        return wrapper.wrap(req, invocation);
    }

    private void handleError(Req req, Throwable e) {
        req.revert();
        req.async();
        HttpIO.INSTANCE.error(req, e, LogLevel.ERROR);
        req.done();
    }

    private void complete(Channel ctx, boolean isKeepAlive, MediaType contentType, Req req, Object result) {
        U.must((result != null ? 1 : 0) != 0, (String)"The post-processed result cannot be null!");
        U.must((!(result instanceof Req) ? 1 : 0) != 0, (String)"The post-processed result cannot be a Req instance!");
        U.must((!(result instanceof Resp) ? 1 : 0) != 0, (String)"The post-processed result cannot be a Resp instance!");
        if (result instanceof Throwable) {
            this.handleError(req, (Throwable)result);
            return;
        }
        if (result == HttpStatus.ERROR) {
            this.complete(ctx, isKeepAlive, contentType, req, U.rte((String)"Handler error!"));
            return;
        }
        if (result == HttpStatus.NOT_FOUND) {
            this.http.notFound(ctx, isKeepAlive, contentType, this.handler, req);
            return;
        }
        if (result == HttpStatus.ASYNC) {
            return;
        }
        this.processNormalResult(req, result);
    }

    private void processNormalResult(Req req, Object result) {
        HttpUtils.resultToResponse(req, result);
        if (!req.isAsync()) {
            req.done();
        }
    }
}

