/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import java.util.concurrent.atomic.AtomicReference;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.TransactionMode;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpWrapper;
import org.rapidoid.http.Req;
import org.rapidoid.http.RespBody;
import org.rapidoid.http.handler.HandlerInvocation;
import org.rapidoid.http.impl.BodyRenderer;
import org.rapidoid.jpa.JPA;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;

public class HttpTxWrapper
extends RapidoidThing
implements HttpWrapper {
    private final TransactionMode txMode;

    public HttpTxWrapper(TransactionMode txMode) {
        this.txMode = txMode;
    }

    @Override
    public Object wrap(final Req req, final HandlerInvocation invocation) {
        final AtomicReference<Throwable> resultHolder = new AtomicReference<Throwable>();
        U.must((this.txMode != null && this.txMode != TransactionMode.NONE ? 1 : 0) != 0);
        boolean readOnly = this.txMode == TransactionMode.AUTO ? HttpUtils.isGetReq(req) : this.txMode == TransactionMode.READ_ONLY;
        try {
            JPA.transaction((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object res = invocation.invokeAndTransformResultCatchingErrors(new Mapper<Object, Object>(){

                        public Object map(Object result) {
                            if (result instanceof Throwable) {
                                return result;
                            }
                            RespBody body = BodyRenderer.resultToRespBody(req.response(), result);
                            return body;
                        }
                    });
                    if (res instanceof Throwable) {
                        Throwable err = (Throwable)res;
                        throw U.rte((String)"Error occurred inside the transactional web handler!", (Throwable)err);
                    }
                    resultHolder.set(res);
                }
            }, (boolean)readOnly);
        }
        catch (Throwable e) {
            resultHolder.set(e);
        }
        return resultHolder.get();
    }
}

